/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model.app;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.smartcard.app.filesystem.CardFileInfo;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.cardterminal.CardTerminalTools;
import de.intarsys.security.smartcard.cardterminal.ICardTerminalProduct;
import de.intarsys.security.smartcard.cardterminal.IPinEntryApplication;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.security.smartcard.model.CardHolderCertificate;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardApplicationInfo;
import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.security.smartcard.model.ICardOperatingSystem;
import de.intarsys.security.smartcard.model.ICommand;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.AbstractCardApplication;
import de.intarsys.security.smartcard.model.app.CardApplicationBinding;
import de.intarsys.security.smartcard.model.app.CardApplicationCardReset;
import de.intarsys.security.smartcard.model.app.CardApplicationCardUnavailable;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardApplicationTools;
import de.intarsys.security.smartcard.model.app.CardAuthenticationCanceledException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationFailedException;
import de.intarsys.security.smartcard.model.app.PACKAGE;
import de.intarsys.security.smartcard.model.app.SpeRequiredException;
import de.intarsys.security.smartcard.model.cmd.ICmdInternalAuthenticate;
import de.intarsys.security.smartcard.model.cmd.ICmdManageSecurityEnvironment;
import de.intarsys.security.smartcard.model.cmd.ICmdVerify;
import de.intarsys.tools.activity.IPrompter;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.authenticate.PasswordProvider;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.IMessageBundleSupport;
import de.intarsys.tools.message.LiteralMessage;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class CardApplicationAdapter
extends AbstractCardApplication {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(CardApplicationAdapter.class);
    private ICardApplicationInfo cardApplicationInfo;
    private CardFileSelector applicationPath;
    private IPinEntryApplication pinEntryApplication;
    private Integer restrictionCount;
    private Collection<IPinInfo> supportedPinInfos;
    private boolean extendedApdu = false;

    protected CardApplicationAdapter() {
    }

    @Override
    public void authenticate() throws CardApplicationException {
        this.basicBeginTransaction();
        if (this.getAuthenticationPath() == null || this.getAuthenticationPinInfo() == null) {
            return;
        }
        this.basicAuthenticatePrepare();
        try {
            this.basicAuthenticate(this.getAuthenticationPath());
        }
        catch (CardAuthenticationFailedException e) {
            this.setAuthenticationPin(null);
            throw e;
        }
    }

    protected void basicAuthenticate(CardFileSelector dir) throws CardApplicationException {
        this.getFileSystem().selectDf(dir, false);
        if (this.isVerified(this.getAuthenticationPinInfo())) {
            return;
        }
        if (!CryptoTools.isEmpty((Secret)this.getAuthenticationPin())) {
            this.cmdVerify(this.getAuthenticationPinInfo(), this.getAuthenticationPin());
        } else if (this.isSupportedSPE()) {
            this.basicAuthenticateSpe();
        } else {
            if (this.isEnforceSPE()) {
                throw new SpeRequiredException();
            }
            this.basicAuthenticateGui();
        }
    }

    protected void basicAuthenticateGui() throws CardApplicationException {
        IMessage title = Msg.getMessage("CardApplicationAdapter.VerifyRequest.title", new Object[0]);
        IMessage prompt = this.getAuthenticationPromptExpanded(false);
        Secret pin = this.queryPin(title, prompt);
        this.cmdVerify(this.getAuthenticationPinInfo(), pin);
    }

    protected void basicAuthenticatePrepare() throws CardApplicationException {
    }

    protected void basicAuthenticateSpe() throws CardApplicationException {
        IMessage prompt = this.getAuthenticationPromptExpanded(true);
        this.cmdVerifySpe(this.getAuthenticationPinInfo(), prompt);
    }

    protected void basicBeginTransaction() throws CardApplicationException {
        if (!this.getCardConnection().isTransactionActive()) {
            try {
                Future f = this.getCardConnection().beginTransaction(null);
                f.get(5000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw CardApplicationException.create(e);
            }
        }
    }

    @Override
    protected void basicReset() throws CardApplicationException {
        this.basicResetSecurityState();
    }

    protected void basicResetFileSystem() throws CardApplicationException {
        if (!this.getCardProduct().hasRoot()) {
            return;
        }
        try {
            this.getFileSystem().selectRoot(false);
        }
        catch (CardApplicationCardUnavailable e) {
            throw e;
        }
        catch (CardApplicationCardReset e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final void basicResetSecurityState() throws CardApplicationException {
        this.setVerifiedPinInfo(null);
        this.setCardTransmitter(null);
        this.basicResetUseCount();
        this.basicResetSecurityStateCard();
        this.basicResetFileSystem();
    }

    protected void basicResetSecurityStateCard() {
    }

    protected void basicResetUseCount() {
    }

    protected ResponseAPDU cmd(int cla, int ins, int p1, int p2, byte[] data, int le) throws CardApplicationException {
        return this.cmd(null, cla, ins, p1, p2, data, le);
    }

    protected ResponseAPDU cmd(String label, int cla, int ins, int p1, int p2, byte[] data, int le) throws CardApplicationException {
        RequestAPDU req = new RequestAPDU(cla, ins, p1, p2, data, le, false);
        return this.sendRequest(null, req);
    }

    protected ResponseAPDU cmdInternalAuthenticate(byte[] data, int keySize) throws CardApplicationException {
        ICmdInternalAuthenticate cmd = this.getCommand(ICmdInternalAuthenticate.class);
        RequestAPDU req = cmd.create(data, keySize);
        ResponseAPDU resp = this.sendRequest(cmd, req);
        return resp;
    }

    protected ResponseAPDU cmdMseRestore(int securityEnvId) throws CardApplicationException {
        ICmdManageSecurityEnvironment mse = this.getCommand(ICmdManageSecurityEnvironment.class);
        RequestAPDU req = mse.createRestore(securityEnvId);
        return this.sendRequest(mse, req);
    }

    protected ResponseAPDU cmdVerify(IPinInfo pinRef) throws CardApplicationException {
        ICmdVerify cmdVerify = this.getCommand(ICmdVerify.class);
        RequestAPDU req = cmdVerify.create(pinRef.getReference());
        return this.transmit(req);
    }

    protected ResponseAPDU cmdVerify(IPinInfo pinRef, Secret secret) throws CardApplicationException {
        byte[] pinBlock;
        IPinCodec pinCodec = pinRef.getPinCodec();
        try {
            pinBlock = pinCodec.encode(secret.getChars());
        }
        catch (GeneralSecurityException e) {
            throw new CardApplicationException(e);
        }
        ICmdVerify cmdVerify = this.getCommand(ICmdVerify.class);
        RequestAPDU req = cmdVerify.create(pinRef.getReference(), pinBlock);
        ResponseAPDU resp = this.sendRequest(cmdVerify, req);
        this.setVerifiedPinInfo(pinRef);
        return resp;
    }

    protected ResponseAPDU cmdVerifySpe(IPinInfo pinInfo, IMessage msg) throws CardApplicationException {
        IPinCodec pinCodec = pinInfo.getPinCodec();
        ICmdVerify cmdVerify = this.getCommand(ICmdVerify.class);
        RequestAPDU apdu = cmdVerify.create(pinInfo.getReference(), pinCodec.getTemplate());
        ResponseAPDU response = this.getPinEntryApplication().sendVerifyRequest(apdu, pinInfo.getPinCodec(), msg);
        this.getCardProduct().checkResponse(apdu, response);
        this.setVerifiedPinInfo(pinInfo);
        return response;
    }

    protected Collection<ICardHolderCertificate> createCardHolderCertificates(Collection<CardApplicationBinding> bindings) {
        ArrayList<ICardHolderCertificate> certs = new ArrayList<ICardHolderCertificate>(bindings.size());
        for (CardApplicationBinding binding : bindings) {
            CardHolderCertificate cert = CardHolderCertificate.create(this.getCardProduct(), this.getCardConnection(), binding.getCardHolderCertificateInfo());
            if (cert == null || !this.getCardProduct().acceptCardHolderCertificate(cert)) continue;
            certs.add(cert);
        }
        return certs;
    }

    public CardFileSelector getApplicationPath() {
        return this.applicationPath;
    }

    protected CardFileSelector getAuthenticationPath() {
        if (this.getAuthenticationPinInfo() == null) {
            return null;
        }
        return this.getAuthenticationPinInfo().getDirectory();
    }

    protected abstract IPinInfo getAuthenticationPinInfo();

    protected IMessage getAuthenticationPrompt(String messageKey, String template, ICard card, IPinInfo pinInfo, IX509PublicKeyCertificate certificate, boolean securePinEntry) {
        IMessage defaultPrompt = CardApplicationTools.getAuthenticationPrompt(card, pinInfo, certificate, securePinEntry);
        if (StringTools.isEmpty((String)template)) {
            return defaultPrompt;
        }
        Args args = Args.create();
        String terminalLabel = card.getCardTerminal().getName();
        String pinLabel = pinInfo.getLabel();
        String subjectLabel = CertificateTools.getSubjectLabel((IX509Certificate)certificate);
        String usageLabel = CertificateTools.getUsageLabel((IX509PublicKeyCertificate)certificate);
        String restrictionLabel = CertificateTools.getRestrictionLabel((IX509PublicKeyCertificate)certificate);
        ArgTools.putPath((IArgs)args, (String)"prompt.default", (Object)defaultPrompt);
        ArgTools.putPath((IArgs)args, (String)"prompt.cardreader", (Object)terminalLabel);
        ArgTools.putPath((IArgs)args, (String)"prompt.pin", (Object)pinLabel);
        ArgTools.putPath((IArgs)args, (String)"prompt.subject", (Object)subjectLabel);
        ArgTools.putPath((IArgs)args, (String)"prompt.usage", (Object)usageLabel);
        ArgTools.putPath((IArgs)args, (String)"prompt.restriction", (Object)restrictionLabel);
        String text = TemplateEvaluator.evaluateString((Mode)Mode.UNTRUSTED, (String)template, (IArgs)args);
        return LiteralMessage.create((String)messageKey, (String)text, (Object[])new Object[]{this, pinInfo, certificate});
    }

    @Override
    public IMessage getAuthenticationPromptExpanded() {
        return this.getAuthenticationPromptExpanded(this.isSupportedSPE());
    }

    protected IMessage getAuthenticationPromptExpanded(boolean securePinEntry) {
        String code = this.getMsgPromptCodeAuthentication();
        return this.getAuthenticationPrompt(code, this.getAuthenticationPrompt(), this.getCard(), this.getAuthenticationPinInfo(), null, securePinEntry);
    }

    protected List<CardApplicationBinding> getBindings() {
        return this.getCardApplicationInfo().getBindings();
    }

    public ICardApplicationInfo getCardApplicationInfo() {
        return this.cardApplicationInfo;
    }

    protected abstract Class<? extends ICardApplication> getCardApplicationType();

    protected ICardOperatingSystem getCardOperatingSystem() {
        return this.getCardProduct().getCardOperatingSystem();
    }

    protected ICardTerminalProduct getCardTerminalProduct() {
        return CardTerminalTools.getCardTerminalProduct(this.getCardConnection());
    }

    protected <T extends ICommand> T getCommand(Class<T> command) {
        return this.getCardOperatingSystem().getCommand(command);
    }

    protected CardFileSelector getCurrentDf() {
        return this.getConnectionState().getCurrentDf();
    }

    protected CardFileInfo getCurrentDfFileInfo() {
        return this.getConnectionState().getCurrentDfFileInfo();
    }

    protected CardFileSelector getCurrentEf() {
        return this.getConnectionState().getCurrentEf();
    }

    protected CardFileInfo getCurrentEfFileInfo() {
        return this.getConnectionState().getCurrentEfFileInfo();
    }

    protected CardFileSelector getDefaultApplicationPath() {
        return null;
    }

    protected Collection<IPinInfo> getDefaultPinInfos() {
        return this.getCardInfo().getPinInfos();
    }

    protected int getDefaultRestrictionCount() {
        return -1;
    }

    protected IFileSystemApplication getFileSystem() throws CardApplicationException {
        return this.getCardProduct().createCardApplication(this.getCardConnection(), IFileSystemApplication.class);
    }

    protected IMessage getMessage(String key, Object ... args) {
        IMessage message;
        if (this.getCardProduct() instanceof IMessageBundleSupport && (message = ((IMessageBundleSupport)this.getCardProduct()).getMessageBundle().getMessage(key, args)).getPattern() != null) {
            return message;
        }
        return this.getMessageBundle().getMessage(key, args);
    }

    protected IMessageBundle getMessageBundle() {
        return Msg;
    }

    protected String getMsgPromptCodeAuthentication() {
        return this.getMsgPromptCodePrefix() + ".activity.enterPin";
    }

    protected abstract String getMsgPromptCodePrefix();

    protected IPinEntryApplication getPinEntryApplication() throws CardApplicationException {
        if (this.pinEntryApplication == null) {
            ICardTerminalProduct cardTerminalProduct = CardTerminalTools.getCardTerminalProduct(this.getCardConnection());
            this.pinEntryApplication = cardTerminalProduct.createCardApplication(this.getCardConnection(), IPinEntryApplication.class);
        }
        return this.pinEntryApplication;
    }

    protected IPinInfo getPinInfoCAN() {
        return this.getCardProduct().getCardInfo().lookupPinInfo("PIN.CAN");
    }

    public int getRestrictionCount() {
        if (this.restrictionCount == null) {
            return this.getDefaultRestrictionCount();
        }
        return this.restrictionCount;
    }

    public Collection<IPinInfo> getSupportedPinInfos() {
        return this.supportedPinInfos;
    }

    protected IPinInfo getVerifiedPinInfo() {
        return this.getConnectionState().getVerifiedPinInfo();
    }

    @PostConstruct
    public void initialize() throws CardApplicationException {
        this.setExtendedApdu(this.getCardInfo().supportsExtendedApdu());
        this.initializePinInfos();
        this.initializeApplicationPath();
        if (!this.getConnectionState().isInitialized()) {
            this.getConnectionState().setInitialized(true);
            this.reset();
        }
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace(this + " created");
        }
    }

    protected void initializeApplicationPath() throws CardApplicationException {
        String applicationPathName = ElementTools.getString((IElement)this.getConfiguration(), (String)"directory", null);
        if (!StringTools.isEmpty((String)applicationPathName)) {
            CardFileSelector selector = this.getCardInfo().lookupFileSelector(applicationPathName);
            if (selector == null) {
                throw new CardApplicationException("card file " + applicationPathName + " not found");
            }
            this.setApplicationPath(selector);
        } else {
            this.setApplicationPath(this.getDefaultApplicationPath());
        }
    }

    protected void initializePinInfos() throws CardApplicationException {
        IElement elPins = ElementTools.getElement((IElement)this.getConfiguration(), (String)"pins");
        if (elPins != null) {
            this.supportedPinInfos = new ArrayList<IPinInfo>();
            Iterator itItems = elPins.elementIterator("pin");
            while (itItems.hasNext()) {
                IPinInfo info;
                IElement elItem = (IElement)itItems.next();
                String id = elItem.getText();
                if (StringTools.isEmpty((String)id)) {
                    id = elItem.attributeValue("ref", null);
                }
                if ((info = this.getCardInfo().lookupPinInfo(id)) == null) {
                    throw new CardApplicationException("pin " + id + " not found");
                }
                this.supportedPinInfos.add(info);
            }
        } else {
            this.supportedPinInfos = this.getDefaultPinInfos();
        }
    }

    public boolean isExtendedApdu() {
        return this.extendedApdu;
    }

    @Override
    public boolean isSupportedSPE() {
        try {
            return this.getPinEntryApplication().supportsPinVerify(this.getAuthenticationPinInfo().getPinCodec()) && !this.isDisableSPE();
        }
        catch (CardApplicationException e) {
            return false;
        }
    }

    protected boolean isVerified(IPinInfo pinInfo) {
        if (pinInfo == null) {
            return false;
        }
        return pinInfo.equals(this.getVerifiedPinInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Secret queryPin(IMessage title, IMessage prompt) throws CardAuthenticationException {
        IPasswordProvider passwordProvider = this.getPasswordProvider();
        if (passwordProvider == null) {
            passwordProvider = PasswordProvider.get();
        }
        if (passwordProvider == null) {
            String msg = Msg.getString("CardApplicationAdapter.Error.AuthenticationNoDialog", new Object[0]);
            throw new CardAuthenticationFailedException(msg);
        }
        if (passwordProvider instanceof IPrompter) {
            ((IPrompter)passwordProvider).setTitle(title);
            ((IPrompter)passwordProvider).setMessage(prompt);
        }
        try {
            Secret pin = passwordProvider.getPassword();
            if (CryptoTools.isEmpty((Secret)pin)) {
                throw new CardAuthenticationCanceledException();
            }
            Secret secret = pin;
            return secret;
        }
        finally {
            if (passwordProvider instanceof IPrompter) {
                ((IPrompter)passwordProvider).setMessage(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Secret queryPin(String id, IMessage title, IMessage prompt) throws CardAuthenticationException {
        IPasswordProvider passwordProvider = this.getPasswordProvider();
        if (passwordProvider == null) {
            passwordProvider = PasswordProvider.get();
        }
        if (passwordProvider == null) {
            String msg = Msg.getString("CardApplicationAdapter.Error.AuthenticationNoDialog", new Object[0]);
            throw new CardAuthenticationFailedException(msg);
        }
        try {
            IPasswordProvider.PasswordRequestOptions options = new IPasswordProvider.PasswordRequestOptions();
            options.setTitle(title);
            options.setMessage(prompt);
            options.setPasswordId(id);
            Secret pin = passwordProvider.getPassword(options);
            if (CryptoTools.isEmpty((Secret)pin)) {
                throw new CardAuthenticationCanceledException();
            }
            Secret secret = pin;
            return secret;
        }
        finally {
            if (passwordProvider instanceof IPrompter) {
                ((IPrompter)passwordProvider).setMessage(null);
            }
        }
    }

    protected ResponseAPDU sendRequest(ICommand command, RequestAPDU request) throws CardApplicationException {
        request.setExtendedApdu(request.isExtendedApdu() || this.isExtendedApdu());
        ResponseAPDU response = this.transmit(request);
        this.getCardProduct().checkResponse(request, response);
        return response;
    }

    public void setApplicationPath(CardFileSelector applicationPath) {
        this.applicationPath = applicationPath;
    }

    public void setCardApplicationInfo(ICardApplicationInfo cardApplicationInfo) {
        this.cardApplicationInfo = cardApplicationInfo;
    }

    protected void setCurrentDf(CardFileSelector currentPath, CardFileInfo info) {
        this.getConnectionState().setCurrentDf(currentPath, info);
    }

    protected void setCurrentEf(CardFileSelector currentPath, CardFileInfo info) {
        this.getConnectionState().setCurrentEf(currentPath, info);
    }

    public void setExtendedApdu(boolean extendedApdu) {
        this.extendedApdu = extendedApdu;
    }

    public void setRestrictionCount(int restrictionCount) {
        if (this.restrictionCount != null) {
            throw new InvalidRequestException("already set");
        }
        this.restrictionCount = restrictionCount;
    }

    protected void setVerifiedPinInfo(IPinInfo pinInfo) {
        this.getConnectionState().setVerifiedPinInfo(pinInfo);
    }

    public String toString() {
        return this.getClass().getName() + " @ " + StringTools.safeString((Object)this.getCardConnection());
    }

    protected ResponseAPDU transmit(RequestAPDU req) throws CardApplicationException {
        try {
            ResponseAPDU resp = this.getCardTransmitter().transmit(req);
            return resp;
        }
        catch (Exception e) {
            throw CardApplicationException.create(e);
        }
    }
}

