/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model.app;

import de.intarsys.security.smartcard.card.CardConnectionDetector;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CardProductTools;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.app.ICardApplicationFilter;
import de.intarsys.tools.collection.ListTools;
import java.util.List;

public class CardApplicationDetector<R extends Result<A>, A extends ICardApplication>
extends CardConnectionDetector<R> {
    private final Class<A> cardApplicationClass;
    private ICardApplicationFilter cardApplicationFilter;

    public CardApplicationDetector(Class<A> pCardApplicationClass) {
        this.cardApplicationClass = pCardApplicationClass;
    }

    protected List<R> findForApplication(A app) {
        return ListTools.with((Object[])new Result[]{new Result<A>(app)});
    }

    protected List<R> findForConnection(ICardConnection connection) {
        try {
            ICardProduct product = CardProductTools.getCardProduct(connection);
            A app = product.createCardApplication(connection, this.cardApplicationClass);
            if (this.getCardApplicationFilter() == null) {
                return this.findForApplication(app);
            }
            if (this.getCardApplicationFilter().accept((ICardApplication)app)) {
                return this.findForApplication(app);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public ICardApplicationFilter getCardApplicationFilter() {
        return this.cardApplicationFilter;
    }

    public void setCardApplicationFilter(ICardApplicationFilter cardApplicationFilter) {
        this.cardApplicationFilter = cardApplicationFilter;
    }

    public static class Result<A extends ICardApplication>
    extends CardConnectionDetector.Result {
        private final A application;

        public Result(A app) {
            super(app.getCardConnection());
            this.application = app;
        }

        public A getApplication() {
            return this.application;
        }
    }
}

