/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model.app;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.CertificateUsage;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.smartcard.app.common.IQSignApplication;
import de.intarsys.security.smartcard.app.common.ISignApplication;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CardProductTools;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.ICardHolderApplication;
import de.intarsys.security.smartcard.model.app.PACKAGE;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.TaggedAttribute;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import java.util.Collection;

public class CardApplicationTools {
    private static Attribute ATTR_CARDHOLDERCERTIFICATES = new Attribute("cardHolderCertificates");
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public static IMessage getAuthenticationPrompt(ICard card, IPinInfo pinInfo, IX509PublicKeyCertificate certificate, boolean securePinEntry) {
        String terminalLabel = card.getCardTerminal().getName();
        String pinLabel = pinInfo.getLabel();
        if (certificate == null) {
            if (securePinEntry) {
                return Msg.getMessage("CardApplicationTools.authenticationPromptSPEPlain", new Object[]{terminalLabel, pinLabel});
            }
            return Msg.getMessage("CardApplicationTools.authenticationPromptGUIPlain", new Object[]{terminalLabel, pinLabel});
        }
        String subjectLabel = CertificateTools.getSubjectLabel((IX509Certificate)certificate);
        String usageLabel = CertificateTools.getUsageLabel((IX509PublicKeyCertificate)certificate);
        String restrictionLabel = CertificateTools.getRestrictionLabel((IX509PublicKeyCertificate)certificate);
        if (securePinEntry) {
            return Msg.getMessage("CardApplicationTools.authenticationPromptSPECertificate", new Object[]{terminalLabel, pinLabel, subjectLabel, usageLabel, restrictionLabel});
        }
        return Msg.getMessage("CardApplicationTools.authenticationPromptGUICertificate", new Object[]{terminalLabel, pinLabel, subjectLabel, usageLabel, restrictionLabel});
    }

    public static synchronized <T extends ICardApplication> Collection<ICardHolderCertificate> getCardHolderCertificates(ICard card, Class<T> applicationType, ICardConnection connection) throws CardApplicationException {
        TaggedAttribute attr = new TaggedAttribute((Object)ATTR_CARDHOLDERCERTIFICATES, applicationType);
        Collection<ICardHolderCertificate> certs = (Collection<ICardHolderCertificate>)card.getAttribute((Object)attr);
        if (certs != null) {
            return certs;
        }
        if (connection == null) {
            throw new CardApplicationException("card holder certificates not available");
        }
        ICardProduct product = CardProductTools.getCardProduct(connection);
        T app = product.createCardApplication(connection, applicationType);
        ICardHolderApplication certSupport = (ICardHolderApplication)app;
        certs = certSupport.getSupportedCardHolderCertificates();
        card.setAttribute((Object)attr, certs);
        return certs;
    }

    public static Class<? extends ISignApplication> getSignApplicationType(boolean nonRepudiation) {
        if (nonRepudiation) {
            return IQSignApplication.class;
        }
        return ISignApplication.class;
    }

    public static Class<? extends ICardApplication> getSignApplicationType(CertificateUsage certificateUsage) {
        if (certificateUsage != null && certificateUsage.isSignatureWithNonRepudiation()) {
            return IQSignApplication.class;
        }
        return ISignApplication.class;
    }

    private CardApplicationTools() {
    }
}

