/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model.app;

import de.intarsys.security.smartcard.model.app.CardAuthenticationException;
import de.intarsys.security.smartcard.model.app.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;

public class CardAuthenticationFailedException
extends CardAuthenticationException {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public CardAuthenticationFailedException(int sw1, int sw2) {
        super(sw1, sw2);
    }

    public CardAuthenticationFailedException(String message) {
        super(0, 0, message);
    }

    @Override
    public String getLocalizedMessage() {
        int sw1 = this.getSw1();
        int sw2 = this.getSw2();
        if (sw1 == 0 && sw2 == 0) {
            return super.getLocalizedMessage();
        }
        switch (sw1) {
            case 99: {
                if (sw2 < 192 || sw2 >= 208) break;
                return Msg.getString("CardAuthenticationFailedException.FailedRetries", new Object[]{sw2 & 0xF});
            }
            case 100: {
                switch (sw2) {
                    case 0: {
                        return Msg.getString("CardAuthenticationFailedException.Timeout", new Object[0]);
                    }
                    case 1: {
                        return Msg.getString("CardAuthenticationFailedException.Canceled", new Object[0]);
                    }
                    case 2: {
                        return Msg.getString("CardAuthenticationFailedException.NewPinsDontMatch", new Object[0]);
                    }
                    case 3: {
                        return Msg.getString("CardAuthenticationFailedException.PinWrongLength", new Object[0]);
                    }
                    case 4: {
                        return Msg.getString("CardAuthenticationFailedException.PinFirewall", new Object[0]);
                    }
                }
                break;
            }
            case 105: {
                switch (sw2) {
                    case 130: {
                        return Msg.getString("CardAuthenticationFailedException.PinPukMaxUsageExceeded", new Object[0]);
                    }
                    case 131: {
                        return Msg.getString("CardAuthenticationFailedException.PinBlocked", new Object[0]);
                    }
                    case 132: {
                        return Msg.getString("CardAuthenticationFailedException.PinBlocked", new Object[0]);
                    }
                    case 133: {
                        return Msg.getString("CardAuthenticationFailedException.6985", new Object[0]);
                    }
                }
                break;
            }
            case 106: {
                switch (sw2) {
                    case 135: {
                        return Msg.getString("CardAuthenticationFailedException.PinWrongLength", new Object[0]);
                    }
                }
                break;
            }
        }
        return Msg.getString("CardAuthenticationFailedException.Failed", new Object[0]);
    }
}

