/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model.app;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.AllCertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.security.smartcard.model.app.CardApplicationDetector;
import de.intarsys.security.smartcard.model.app.ICardHolderApplication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CardHolderCertificateDetector<R extends Result<A>, A extends ICardApplication>
extends CardApplicationDetector<R, A> {
    private IX509CertificateFilter certificateFilter = AllCertificateFilter.UNIQUE;

    public CardHolderCertificateDetector(Class<A> pCardApplicationClass) {
        super(pCardApplicationClass);
    }

    @Override
    protected List<R> findForApplication(A app) {
        ICardHolderApplication certSupport = (ICardHolderApplication)app;
        Collection<ICardHolderCertificate> certs = certSupport.getSupportedCardHolderCertificates();
        ArrayList<R> result = new ArrayList<R>();
        for (ICardHolderCertificate certificate : certs) {
            if (this.getCertificateFilter() == null) {
                result.add(this.findForCertificate(app, certificate));
                continue;
            }
            if (!this.getCertificateFilter().accept((IX509Certificate)certificate)) continue;
            result.add(this.findForCertificate(app, certificate));
        }
        return result;
    }

    protected R findForCertificate(A app, ICardHolderCertificate certificate) {
        return (R)((Object)new Result<A>(app, certificate));
    }

    public IX509CertificateFilter getCertificateFilter() {
        return this.certificateFilter;
    }

    public void setCertificateFilter(IX509CertificateFilter certificateFilter) {
        this.certificateFilter = certificateFilter;
    }

    public static class Result<A extends ICardApplication>
    extends CardApplicationDetector.Result<A> {
        private final ICardHolderCertificate cardHolderCertificate;

        public Result(A app, ICardHolderCertificate cert) {
            super(app);
            this.cardHolderCertificate = cert;
        }

        public ICardHolderCertificate getCardHolderCertificate() {
            return this.cardHolderCertificate;
        }
    }
}

