/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model.app;

import de.intarsys.security.smartcard.app.filesystem.CardFileInfo;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardTransmitter;
import de.intarsys.security.smartcard.card.T0CardTransmitter;
import de.intarsys.security.smartcard.card.T1CardTransmitter;
import de.intarsys.security.smartcard.environment.SmartcardEnvironment;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.authenticate.IPasswordProvider;

public class ConnectionState {
    private static final Attribute ATTR_STATE = new Attribute("state");
    private final ICardConnection cardConnection;
    private ICardTransmitter cardTransmitter;
    private IPasswordProvider passwordProvider;
    private IPinInfo verifiedPinInfo;
    private boolean disableSPE;
    private boolean enforceSPE;
    private CardFileSelector currentEf;
    private CardFileInfo currentEfFileInfo;
    private CardFileSelector currentDf = CardFilePath.ROOT;
    private CardFileInfo currentDfFileInfo;
    private boolean initialized = false;

    protected static synchronized ConnectionState create(ICardConnection connection) {
        ConnectionState result = (ConnectionState)connection.getAttribute((Object)ATTR_STATE);
        if (result == null) {
            result = new ConnectionState(connection);
            connection.setAttribute((Object)ATTR_STATE, (Object)result);
        }
        return result;
    }

    protected ConnectionState(ICardConnection connection) {
        this.cardConnection = connection;
        this.enforceSPE = SmartcardEnvironment.get().isEnforceSPE();
        this.disableSPE = SmartcardEnvironment.get().isDisableSPE();
    }

    public ICardConnection getCardConnection() {
        return this.cardConnection;
    }

    public ICardTransmitter getCardTransmitter() {
        return this.cardTransmitter;
    }

    public CardFileSelector getCurrentDf() {
        return this.currentDf;
    }

    public CardFileInfo getCurrentDfFileInfo() {
        return this.currentDfFileInfo;
    }

    public CardFileSelector getCurrentEf() {
        return this.currentEf;
    }

    public CardFileInfo getCurrentEfFileInfo() {
        return this.currentEfFileInfo;
    }

    public IPasswordProvider getPasswordProvider() {
        return this.passwordProvider;
    }

    public IPinInfo getVerifiedPinInfo() {
        return this.verifiedPinInfo;
    }

    public boolean isDisableSPE() {
        return this.disableSPE;
    }

    public boolean isEnforceSPE() {
        return this.enforceSPE;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    public void setCardTransmitter(ICardTransmitter cardTransmitter) {
        this.cardTransmitter = cardTransmitter;
        if (cardTransmitter == null) {
            this.cardTransmitter = this.getCardConnection().getProtocol() == 1 ? new T0CardTransmitter((ICardTransmitter)this.getCardConnection()) : new T1CardTransmitter((ICardTransmitter)this.getCardConnection());
        }
    }

    public void setCurrentDf(CardFileSelector pPath, CardFileInfo pInfo) {
        this.setVerifiedPinInfo(null);
        this.currentDf = pPath;
        this.currentDfFileInfo = pInfo;
    }

    public void setCurrentEf(CardFileSelector pFile, CardFileInfo pInfo) {
        this.currentEf = pFile;
        this.currentEfFileInfo = pInfo;
    }

    public void setDisableSPE(boolean enableSPE) {
        this.disableSPE = enableSPE;
    }

    public void setEnforceSPE(boolean enforceSPE) {
        this.enforceSPE = enforceSPE;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void setPasswordProvider(IPasswordProvider passwordProvider) {
        this.passwordProvider = passwordProvider;
    }

    public void setVerifiedPinInfo(IPinInfo verifiedPinInfo) {
        this.verifiedPinInfo = verifiedPinInfo;
    }
}

