/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model.app;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CardApplicationInfo;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

public class GenericCardApplicationFactory<A extends ICardApplication> {
    private final IFactory<A> factory;

    public GenericCardApplicationFactory(IFactory<A> factory) {
        this.factory = factory;
    }

    public A createCardApplication(ICardConnection connection, ICardProduct product, CardApplicationInfo info) throws CardApplicationException {
        try {
            Args args = Args.create();
            ArgTools.putPath((IArgs)args, (String)"properties.cardConnection", (Object)connection);
            ArgTools.putPath((IArgs)args, (String)"properties.cardProduct", (Object)product);
            ArgTools.putPath((IArgs)args, (String)"properties.cardApplicationInfo", (Object)info);
            return (A)((ICardApplication)this.factory.createInstance((IArgs)args));
        }
        catch (ObjectCreationException e) {
            throw CardApplicationException.create(e);
        }
    }

    public Class<? extends A> getCardApplicationType() {
        return this.factory.getResultType();
    }

    public IFactory<A> getFactory() {
        return this.factory;
    }
}

