/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.model.cmd;

import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.model.ICommand;
import de.intarsys.security.smartcard.model.cmd.AbstractCmd;

public class GenericCommand
extends AbstractCmd {
    private boolean sensitiveContent = false;
    private int cla;
    private int ins;
    private int p1;
    private int p2;
    private byte[] data;
    private String label;

    public GenericCommand(int cla, int ins, int p1, int p2) {
        this.cla = cla;
        this.ins = ins;
        this.p1 = p1;
        this.p2 = p2;
        this.data = null;
    }

    public GenericCommand(int cla, int ins, int p1, int p2, byte[] data) {
        this.cla = cla;
        this.ins = ins;
        this.p1 = p1;
        this.p2 = p2;
        this.data = data;
    }

    public RequestAPDU create() {
        RequestAPDU apdu = new RequestAPDU(this.getCla(), this.getIns(), this.getP1(), this.getP2(), this.getData(), false);
        apdu.setLabel(this.getLabel());
        apdu.setSensitiveContent(this.isSensitiveContent());
        return apdu;
    }

    @Override
    public int getCla() {
        return this.cla;
    }

    @Override
    public Class getCommandType() {
        return ICommand.class;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public int getIns() {
        return this.ins;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public int getP1() {
        return this.p1;
    }

    public int getP2() {
        return this.p2;
    }

    public boolean isSensitiveContent() {
        return this.sensitiveContent;
    }

    public void setCla(int cla) {
        this.cla = cla;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setIns(int ins) {
        this.ins = ins;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setP1(int p1) {
        this.p1 = p1;
    }

    public void setP2(int p2) {
        this.p2 = p2;
    }

    public void setSensitiveContent(boolean sensitiveContent) {
        this.sensitiveContent = sensitiveContent;
    }
}

