/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.module.common;

import de.intarsys.security.smartcard.app.common.AbstractAuthenticateApp;
import de.intarsys.security.smartcard.app.common.IAuthenticateApplication;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.module.common.CardFunction;
import de.intarsys.security.smartcard.module.common.CardModule;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorExecutionException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.infoset.IElement;

public class FunctionLauncherApp
extends AbstractAuthenticateApp
implements IAuthenticateApplication {
    private String functionName;

    @Override
    protected byte[] basicSign(byte[] data) throws CardApplicationException {
        this.perform();
        return new byte[0];
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        this.setFunctionName(element.attributeValue("function", null));
    }

    @Override
    public IPinInfo getAuthenticationPinInfo() {
        return null;
    }

    @Override
    protected Class<? extends ICardApplication> getCardApplicationType() {
        return FunctionLauncherApp.class;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Object perform() throws CardApplicationException {
        CardModule module = this.getCardProduct().getModule();
        if (module == null) {
            throw new CardApplicationException("no card module");
        }
        CardFunction function = module.getFunction(this.getFunctionName());
        if (function == null) {
            throw new CardApplicationException("no card function " + this.getFunctionName());
        }
        Args args = Args.create();
        args.put("connection", (Object)this.getCardConnection());
        FunctorCall call = new FunctorCall(null, (IArgs)args);
        try {
            return function.perform((IFunctorCall)call);
        }
        catch (FunctorExecutionException e) {
            throw CardApplicationException.create(e.getCause());
        }
        catch (FunctorException e) {
            throw CardApplicationException.create(e);
        }
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }
}

