/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.module.js;

import de.intarsys.security.smartcard.card.ATR;
import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.module.js.JCardTerminal;
import de.intarsys.security.smartcard.module.js.JConnection;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.concurrent.TaskFailed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class JCard {
    private static final Attribute ATTR_JS = new Attribute("js");
    private final ICard card;

    public static JCard create(ICard card) {
        if (card == null) {
            return null;
        }
        JCard result = (JCard)card.getAttribute((Object)ATTR_JS);
        if (result == null) {
            result = new JCard(card);
            card.setAttribute((Object)ATTR_JS, (Object)result);
        }
        return result;
    }

    protected JCard(ICard card) {
        this.card = card;
    }

    public JConnection connectExclusive(int protocol) throws CardException {
        ICardConnection connection = this.card.connectExclusive(protocol);
        return JConnection.create(connection);
    }

    public Future<JConnection> connectShared(int protocol, final ITaskCallback<JConnection> callback) {
        final Future f = this.card.connectShared(protocol, (ITaskCallback)new ITaskCallback<ICardConnection>(){

            public void failed(TaskFailed exception) {
                callback.failed(exception);
            }

            public void finished(ICardConnection result) {
                callback.finished((Object)JConnection.create(result));
            }
        });
        return new Future<JConnection>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return f.cancel(mayInterruptIfRunning);
            }

            @Override
            public JConnection get() throws InterruptedException, ExecutionException {
                return JConnection.create((ICardConnection)f.get());
            }

            @Override
            public JConnection get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return JConnection.create((ICardConnection)f.get());
            }

            @Override
            public boolean isCancelled() {
                return f.isCancelled();
            }

            @Override
            public boolean isDone() {
                return f.isDone();
            }
        };
    }

    public ATR getAtr() {
        return this.card.getAtr();
    }

    protected ICard getCard() {
        return this.card;
    }

    public JCardTerminal getCardTerminal() {
        return JCardTerminal.create(this.card.getCardTerminal());
    }

    public boolean isContactless() {
        return this.card.isContactless();
    }
}

