/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.module.js;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.module.js.JCard;
import de.intarsys.security.smartcard.module.js.JCardTerminal;
import de.intarsys.security.smartcard.module.js.JRequest;
import de.intarsys.security.smartcard.module.js.JResponse;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.hex.HexTools;
import java.util.concurrent.Future;

public class JConnection {
    private static final Attribute ATTR_JS = new Attribute("js");
    private final ICardConnection connection;

    public static JConnection create(ICardConnection connection) {
        if (connection == null) {
            return null;
        }
        JConnection result = (JConnection)connection.getAttribute((Object)ATTR_JS);
        if (result == null) {
            result = new JConnection(connection);
            connection.setAttribute((Object)ATTR_JS, (Object)result);
        }
        return result;
    }

    protected JConnection(ICardConnection connection) {
        this.connection = connection;
    }

    public Future<Void> beginTransaction(ITaskCallback<Void> callback) {
        return this.connection.beginTransaction(callback);
    }

    public void close(int mode) throws CardException {
        this.connection.close(mode);
    }

    public byte[] controlMapped(int controlCode, byte[] inBuffer, int inBufferOffset, int inBufferLength, int outBufferSize) throws CardException {
        return this.connection.controlMapped(controlCode, inBuffer, inBufferOffset, inBufferLength, outBufferSize);
    }

    public void endTransaction() throws CardException {
        this.connection.endTransaction();
    }

    public JCard getCard() {
        return JCard.create(this.connection.getCard());
    }

    public JCardTerminal getCardTerminal() {
        return JCardTerminal.create(this.connection.getCardTerminal());
    }

    protected ICardConnection getConnection() {
        return this.connection;
    }

    public int getProtocol() {
        return this.connection.getProtocol();
    }

    public void getStatus() throws CardException {
        this.connection.getStatus();
    }

    public boolean isTransactionActive() {
        return this.connection.isTransactionActive();
    }

    public boolean isValid() {
        return this.connection.isValid();
    }

    public void reconnect(int mode) throws CardException {
        this.connection.reconnect(mode);
    }

    public JResponse request(int cla, int ins, int p1, int p2) throws CardException {
        return this.request(cla, ins, p1, p2, null, 0);
    }

    public JResponse request(int cla, int ins, int p1, int p2, byte[] data) throws CardException {
        return this.request(cla, ins, p1, p2, data, 0);
    }

    public JResponse request(int cla, int ins, int p1, int p2, byte[] data, int le) throws CardException {
        RequestAPDU request = new RequestAPDU(cla, ins, p1, p2, data, le, false);
        return JResponse.create(this.connection.transmit(request));
    }

    public JResponse request(int cla, int ins, int p1, int p2, int le) throws CardException {
        return this.request(cla, ins, p1, p2, null, le);
    }

    public JResponse transmit(JRequest request) throws CardException {
        return JResponse.create(this.connection.transmit(request.getRequest()));
    }

    public JResponse transmit(String hex) throws CardException {
        byte[] bytes = HexTools.hexStringToBytes((String)hex);
        RequestAPDU request = new RequestAPDU(bytes);
        return JResponse.create(this.connection.transmit(request));
    }
}

