/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.security.smartcard.pkcs15.Operations;
import de.intarsys.tools.string.PrettyPrinter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;

public class AlgorithmInfo
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public String getAlgId() {
        ASN1ValueHolder temp = this.getValueHolder().getNextTyped(4, ASN1ObjectIdentifier.class);
        if (temp != null) {
            return temp.toDERObjectIdentifier().getId();
        }
        return null;
    }

    public int getAlgorithm() {
        ASN1Integer derInt = this.getValueHolder().getChild(1).toDERInteger();
        if (derInt != null) {
            return derInt.getValue().intValue();
        }
        return -1;
    }

    public int getAlgRef() {
        ASN1ValueHolder temp = this.getValueHolder().getNextTyped(4, ASN1Integer.class);
        if (temp != null) {
            return temp.toDERInteger().getValue().intValue();
        }
        return -1;
    }

    public Operations getOperations() {
        ASN1ValueHolder o = this.getValueHolder().getChild(3);
        return (Operations)Operations.FACTORY.create((ASN1Encodable)o);
    }

    public ASN1Primitive getParameters() {
        return this.getValueHolder().getChild(2).toASN1Primitive();
    }

    public Integer getReference() {
        ASN1Integer derInt = this.getValueHolder().getChild(0).toDERInteger();
        if (derInt != null) {
            return derInt.getValue().intValue();
        }
        return null;
    }

    public void toString(PrettyPrinter printer) {
        printer.appendMember("reference", (Object)this.getReference(), null);
        printer.appendMember("algorithm", (Object)this.getAlgorithm(), null);
        printer.appendMember("parameters", (Object)this.getParameters(), null);
        printer.appendMember("operations", (Object)this.getOperations(), null);
        printer.appendMember("algId", (Object)this.getAlgId(), null);
        printer.appendMember("algRef", (Object)this.getAlgRef(), null);
    }

    static class Factory
    extends ASN1Based.Factory<AlgorithmInfo> {
        Factory() {
        }
    }
}

