/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.security.smartcard.pkcs15.AuthenticationObjectAny;
import de.intarsys.security.smartcard.pkcs15.AuthenticationObjectPassword;
import de.intarsys.security.smartcard.pkcs15.CommonAuthenticationObjectAttributes;
import de.intarsys.security.smartcard.pkcs15.Identifier;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Object;
import de.intarsys.tools.reflect.ObjectCreationException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;

public abstract class AuthenticationObject
extends Pkcs15Object {
    public static final Factory<AuthenticationObject> FACTORY = new Factory();
    private CommonAuthenticationObjectAttributes commonAuthenticationObjectAttributes;

    protected AuthenticationObject() {
    }

    @Override
    protected ASN1ValueHolder baseGetClassAttributes() {
        if (this.getValueHolder().getChild(2).toASN1Primitive() instanceof ASN1Sequence) {
            return this.getValueHolder().getChild(2);
        }
        return super.baseGetClassAttributes();
    }

    @Override
    public ASN1Based getClassAttributes() {
        return this.getCommonAuthenticationObjectAttributes();
    }

    public CommonAuthenticationObjectAttributes getCommonAuthenticationObjectAttributes() {
        return this.commonAuthenticationObjectAttributes;
    }

    @Override
    public Identifier getIdentifier() {
        return this.getCommonAuthenticationObjectAttributes().getAuthId();
    }

    @Override
    public ASN1Based getSubClassAttributes() {
        return null;
    }

    protected void initializeAfterCreate() {
        super.initializeAfterCreate();
        this.commonAuthenticationObjectAttributes = (CommonAuthenticationObjectAttributes)CommonAuthenticationObjectAttributes.FACTORY.create((ASN1Encodable)this.baseGetClassAttributes());
    }

    public boolean isPin() {
        return false;
    }

    static class Factory<T extends AuthenticationObject>
    extends Pkcs15Object.Factory<T> {
        Factory() {
        }

        protected T basicCreate(ASN1Encodable asn1) throws ObjectCreationException {
            if (asn1 instanceof ASN1TaggedObject) {
                asn1 = ((ASN1TaggedObject)asn1).getBaseObject();
            }
            return (T)((Object)((AuthenticationObject)super.basicCreate(asn1)));
        }

        protected ASN1Based.Factory selectSubtypeFactory(ASN1Encodable o) throws ObjectCreationException {
            if (o == null) {
                return null;
            }
            if (ASN1Tools.isASN1Sequence((ASN1Encodable)o)) {
                return AuthenticationObjectPassword.FACTORY;
            }
            if (ASN1Tools.isASN1Tagged((ASN1Encodable)o)) {
                return AuthenticationObjectAny.FACTORY;
            }
            throw new ObjectCreationException("AuthenticationObject based on " + o + " not supported");
        }
    }
}

