/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.tools.string.PrettyPrinter;

public class CardFlags
extends ASN1Based {
    public static final Factory FACTORY = new Factory();
    public static final int BIT_READONLY = 0;
    public static final int BIT_AUTH_REQUIRED = 1;
    public static final int BIT_PRN_GENERATION = 2;
    protected static final String[] FLAGS = new String[]{"readonly", "authRequired", "prnGeneration"};

    protected byte[] getValue() {
        return this.getValueHolder().toDERBitString().getBytes();
    }

    public boolean isAuthRequired() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)1);
    }

    public boolean isPrnGeneration() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)2);
    }

    public boolean isReadOnly() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)0);
    }

    public void toString(PrettyPrinter printer) {
        ASN1Tools.printBitStringFlags((PrettyPrinter)printer, (byte[])this.getValue(), (String[])FLAGS);
    }

    static class Factory
    extends ASN1Based.Factory<CardFlags> {
        Factory() {
        }
    }
}

