/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.security.smartcard.pkcs15.AlgorithmInfo;
import de.intarsys.security.smartcard.pkcs15.CardFlags;
import de.intarsys.security.smartcard.pkcs15.SecurityEnvironmentInfo;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.string.PrettyPrinter;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERUTF8String;

public class CardInfo
extends ASN1Based {
    public static final Factory FACTORY = new Factory();
    private List<AlgorithmInfo> supportedAlgorithms;

    public CardFlags getCardFlags() {
        ASN1ValueHolder o = this.getValueHolder().getNextTyped(1, DERBitString.class);
        return (CardFlags)CardFlags.FACTORY.create((ASN1Encodable)o);
    }

    public String getHolder() {
        ASN1ValueHolder o = this.getValueHolder().getNextTaggedGetChild(0, 4, false);
        if (o != null) {
            return o.toASN1UTF8String().getString();
        }
        return "";
    }

    public String getIssuer() {
        ASN1ValueHolder o = this.getValueHolder().getNextTaggedGetChild(0, 3, false);
        if (o != null) {
            return o.toASN1UTF8String().getString();
        }
        return "";
    }

    public String getLabel() {
        ASN1ValueHolder o = this.getValueHolder().getNextTaggedGetChild(0, 0, false);
        if (o != null) {
            return o.toASN1UTF8String().getString();
        }
        return "";
    }

    public String getManufacturerID() {
        ASN1ValueHolder o = this.getValueHolder().getNextTyped(1, DERUTF8String.class);
        if (o != null) {
            return o.toASN1UTF8String().getString();
        }
        return "";
    }

    public List<SecurityEnvironmentInfo> getSecurityEnvironmentInfo() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTyped(0, ASN1Sequence.class);
        if (vh != null) {
            ArrayList<SecurityEnvironmentInfo> list = new ArrayList<SecurityEnvironmentInfo>();
            vh.forEach(child -> list.add((SecurityEnvironmentInfo)SecurityEnvironmentInfo.FACTORY.create((ASN1Encodable)child)));
            return list;
        }
        return new ArrayList<SecurityEnvironmentInfo>();
    }

    public String getSerialNumber() {
        ASN1ValueHolder o = this.getValueHolder().getNextTyped(1, ASN1OctetString.class);
        if (o != null) {
            return HexTools.bytesToHexString((byte[])o.toDEROctetString().getOctets());
        }
        return "00";
    }

    public AlgorithmInfo getSupportedAlgorithm(int algorithmRef) {
        for (AlgorithmInfo info : this.getSupportedAlgorithms()) {
            if (info.getReference() != algorithmRef) continue;
            return info;
        }
        return null;
    }

    public List<AlgorithmInfo> getSupportedAlgorithms() {
        return this.supportedAlgorithms;
    }

    public int getVersion() {
        ASN1Integer derInt = this.getValueHolder().getChild(0).toDERInteger();
        if (derInt != null) {
            return derInt.getValue().intValue();
        }
        return 0;
    }

    protected void initializeAfterCreate() {
        super.initializeAfterCreate();
        this.supportedAlgorithms = new ArrayList<AlgorithmInfo>();
        ASN1ValueHolder temp = this.getValueHolder().getNextTaggedGetChild(0, 2, false);
        if (temp != null) {
            for (ASN1ValueHolder tempChild : temp) {
                if (tempChild.isScalar()) {
                    this.supportedAlgorithms.add((AlgorithmInfo)AlgorithmInfo.FACTORY.create((ASN1Encodable)temp));
                    break;
                }
                this.supportedAlgorithms.add((AlgorithmInfo)AlgorithmInfo.FACTORY.create((ASN1Encodable)tempChild));
            }
        }
    }

    public void toString(PrettyPrinter printer) {
        printer.appendMember("version", (Object)this.getVersion(), null);
        printer.appendMember("serialNumber", (Object)this.getSerialNumber(), null);
        printer.appendMember("manufacturerID", (Object)this.getValueHolder().getNextTyped(2, DERUTF8String.class), null);
        printer.appendMember("label", (Object)this.getLabel(), null);
        printer.appendMember("cardFlags", (Object)this.getCardFlags(), null);
        printer.appendMember("seInfo", this.getSecurityEnvironmentInfo(), null);
        printer.appendMember("recordInfo", (Object)this.getValueHolder().getNextTagged(2, 1), null);
        printer.appendMember("supportedAlgorithms", this.getSupportedAlgorithms(), null);
        printer.appendMember("issuerId", (Object)this.getValueHolder().getNextTagged(2, 3), null);
        printer.appendMember("holderId", (Object)this.getValueHolder().getNextTagged(2, 4), null);
        printer.appendMember("lastUpdate", (Object)this.getValueHolder().getNextTagged(2, 5), null);
        printer.appendMember("preferredLanguage", (Object)this.getValueHolder().getNextTyped(2, DERPrintableString.class), null);
        printer.appendMember("profileIndication", (Object)this.getValueHolder().getNextTagged(2, 6), null);
    }

    static class Factory
    extends ASN1Based.Factory<CardInfo> {
        Factory() {
        }
    }
}

