/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.pkcs15.CertificateObjectAny;
import de.intarsys.security.smartcard.pkcs15.CertificateObjectX509;
import de.intarsys.security.smartcard.pkcs15.CommonCertificateAttributes;
import de.intarsys.security.smartcard.pkcs15.Identifier;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Object;
import de.intarsys.tools.reflect.ObjectCreationException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1TaggedObject;

public abstract class CertificateObject
extends Pkcs15Object {
    public static final Factory<CertificateObject> FACTORY = new Factory();
    private CommonCertificateAttributes commonCertificateAttributes;

    protected CertificateObject() {
    }

    public abstract CardFileSelector getCardFileSelector();

    @Override
    public ASN1Based getClassAttributes() {
        return this.getCommonCertificateAttributes();
    }

    public CommonCertificateAttributes getCommonCertificateAttributes() {
        return this.commonCertificateAttributes;
    }

    @Override
    public Identifier getIdentifier() {
        return this.getCommonCertificateAttributes().getIdentifier();
    }

    @Override
    public ASN1Based getSubClassAttributes() {
        return null;
    }

    protected void initializeAfterCreate() {
        super.initializeAfterCreate();
        this.commonCertificateAttributes = (CommonCertificateAttributes)CommonCertificateAttributes.FACTORY.create((ASN1Encodable)this.baseGetClassAttributes());
    }

    @Override
    protected void initializeAfterCreateNew() {
        super.initializeAfterCreateNew();
        this.commonCertificateAttributes = (CommonCertificateAttributes)CommonCertificateAttributes.FACTORY.createNew();
        this.baseSetClassAttributes(this.commonCertificateAttributes.getValueHolder());
    }

    public boolean isX509() {
        return false;
    }

    static class Factory<T extends CertificateObject>
    extends Pkcs15Object.Factory<T> {
        Factory() {
        }

        protected T basicCreate(ASN1Encodable asn1) throws ObjectCreationException {
            if (asn1 instanceof ASN1TaggedObject) {
                ASN1TaggedObject taggedObject = (ASN1TaggedObject)asn1;
                asn1 = taggedObject.getBaseObject();
            }
            return (T)((Object)((CertificateObject)super.basicCreate(asn1)));
        }

        protected ASN1Based.Factory selectSubtypeFactory(ASN1Encodable o) throws ObjectCreationException {
            if (o == null) {
                return null;
            }
            if (ASN1Tools.isASN1Sequence((ASN1Encodable)o)) {
                return CertificateObjectX509.FACTORY;
            }
            if (ASN1Tools.isASN1Tagged((ASN1Encodable)o)) {
                return CertificateObjectAny.FACTORY;
            }
            throw new ObjectCreationException("CertificateObject based on " + o + " not supported");
        }
    }
}

