/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.pkcs15.CertificateObject;
import de.intarsys.security.smartcard.pkcs15.Path;
import de.intarsys.security.smartcard.pkcs15.X509CertificateAttributes;
import org.bouncycastle.asn1.ASN1Encodable;

public class CertificateObjectX509
extends CertificateObject {
    public static final Factory FACTORY = new Factory();
    private X509CertificateAttributes x509CertificateAttributes;

    @Override
    public CardFileSelector getCardFileSelector() {
        X509CertificateAttributes attr = this.getX509CertificateAttributes();
        Path certPath = attr.getValue().getIndirect().getPath();
        return certPath.toCardFileSelector();
    }

    @Override
    public ASN1Based getTypeAttributes() {
        return this.getX509CertificateAttributes();
    }

    public X509CertificateAttributes getX509CertificateAttributes() {
        return this.x509CertificateAttributes;
    }

    @Override
    protected void initializeAfterCreate() {
        super.initializeAfterCreate();
        this.x509CertificateAttributes = (X509CertificateAttributes)X509CertificateAttributes.FACTORY.create((ASN1Encodable)this.baseGetTypeAttributes());
    }

    @Override
    protected void initializeAfterCreateNew() {
        super.initializeAfterCreateNew();
        this.x509CertificateAttributes = (X509CertificateAttributes)X509CertificateAttributes.FACTORY.createNew();
        this.baseSetTypeAttributes(this.x509CertificateAttributes.getValueHolder());
    }

    @Override
    public boolean isX509() {
        return true;
    }

    public static class Factory
    extends CertificateObject.Factory<CertificateObjectX509> {
    }
}

