/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.security.smartcard.app.filesystem.CardFileName;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CiCardInfo;
import de.intarsys.security.smartcard.model.CiCardInfoBuilder;
import de.intarsys.security.smartcard.model.ICardApplicationFactory;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.PinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Structure;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.hex.HexTools;
import java.util.ArrayList;
import java.util.List;

public class CiCardInfoPkcs15Builder
extends CiCardInfoBuilder {
    private final ICardApplicationFactory cardApplicationFactory;
    private final ICardConnection connection;

    public CiCardInfoPkcs15Builder(ICardApplicationFactory cardApplicationFactory, ICardConnection connection) {
        this.cardApplicationFactory = cardApplicationFactory;
        this.connection = connection;
    }

    public ICardApplicationFactory getCardApplicationFactory() {
        return this.cardApplicationFactory;
    }

    public ICardConnection getConnection() {
        return this.connection;
    }

    private PinInfo lookupPinInfo(List<IPinInfo> infos, IPinInfo info) {
        for (IPinInfo ci : infos) {
            if (ci.getDirectory().equals(info.getDirectory()) && ci.getReference() == info.getReference()) {
                return (PinInfo)ci;
            }
            if (!ci.getId().equals(info.getId())) continue;
            return (PinInfo)ci;
        }
        return null;
    }

    protected void mergePinInfos(CiCardInfo cardInfo, Pkcs15Structure pkcs15) {
        ArrayList<IPinInfo> merged = new ArrayList<IPinInfo>();
        ArrayList<PinInfo> hidden = new ArrayList<PinInfo>();
        for (PinInfo pinInfo : pkcs15.getPinInfos()) {
            if (pinInfo.isHidden()) {
                hidden.add(pinInfo);
                continue;
            }
            PinInfo ciPinInfo = this.lookupPinInfo(cardInfo.basicGetPinInfos(), pinInfo);
            if (ciPinInfo != null && ciPinInfo.isHidden()) {
                hidden.add(pinInfo);
                continue;
            }
            merged.add(pinInfo);
            this.configPinInfoLabel(cardInfo, pinInfo, pinInfo.getLabel());
        }
        for (IPinInfo iPinInfo : cardInfo.getPinInfos()) {
            PinInfo tempPinInfo = this.lookupPinInfo(merged, iPinInfo);
            if (tempPinInfo != null) continue;
            merged.add(iPinInfo);
            this.configPinInfoLabel(cardInfo, (PinInfo)iPinInfo, iPinInfo.getLabel());
        }
        for (IPinInfo iPinInfo : merged) {
            if (!hidden.contains(iPinInfo.getResettingPinInfo())) continue;
            ((PinInfo)iPinInfo).setResettingPinInfo(null);
        }
        cardInfo.basicGetPinInfos().clear();
        cardInfo.basicGetPinInfos().addAll(merged);
    }

    @Override
    public void process(CiCardInfo cardInfo) throws ConfigurationException {
        super.process(cardInfo);
        CardFileName pkcs15AID = cardInfo.getPkcs15Name() == null ? null : new CardFileName(HexTools.hexStringToBytes((String)cardInfo.getPkcs15Name()));
        CardFileName applicationAID = cardInfo.getApplicationName() == null ? null : new CardFileName(HexTools.hexStringToBytes((String)cardInfo.getApplicationName()));
        try {
            Pkcs15Structure pkcs15 = Pkcs15Structure.getPkcs15(this.getCardApplicationFactory(), this.connection, pkcs15AID, applicationAID);
            if (pkcs15 != null) {
                this.mergePinInfos(cardInfo, pkcs15);
                cardInfo.setPkcs15Structure(pkcs15);
                cardInfo.basicGetCardCertificateInfos().addAll(pkcs15.getCardHolderCertificateInfos());
            }
        }
        catch (CardApplicationException cardApplicationException) {
            // empty catch block
        }
    }
}

