/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.security.smartcard.pkcs15.Identifier;
import de.intarsys.security.smartcard.pkcs15.Reference;
import de.intarsys.tools.string.PrettyPrinter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERUTF8String;

public class CommonAuthenticationObjectAttributes
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public Identifier getAuthId() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTyped(0, DEROctetString.class);
        if (vh == null) {
            vh = this.getValueHolder().getNextTyped(0, DERUTF8String.class);
        }
        if (vh != null) {
            return (Identifier)Identifier.FACTORY.create((ASN1Encodable)vh);
        }
        return null;
    }

    public Reference getAuthReference() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTyped(0, ASN1Integer.class);
        if (vh != null) {
            return (Reference)Reference.FACTORY.create((ASN1Encodable)vh);
        }
        return null;
    }

    public Reference getSeIdentifier() {
        ASN1TaggedHolder vh = this.getValueHolder().getNextTagged(0, 0);
        if (vh != null) {
            return (Reference)Reference.FACTORY.create((ASN1Encodable)vh);
        }
        return null;
    }

    public void setAuthId(Identifier authId) {
        ASN1ValueHolder vh = this.getValueHolder().getNextTyped(0, DEROctetString.class);
        if (vh != null) {
            vh.setValue(authId.toASN1Primitive());
        }
    }

    public void toString(PrettyPrinter printer) {
        printer.appendMember("authId", (Object)this.getAuthId(), null);
        printer.appendMember("authReference", (Object)this.getAuthReference(), null);
        printer.appendMember("seIdentifier", (Object)this.getSeIdentifier(), null);
    }

    static class Factory
    extends ASN1Based.Factory<CommonAuthenticationObjectAttributes> {
        Factory() {
        }
    }
}

