/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.security.smartcard.pkcs15.Identifier;
import de.intarsys.security.smartcard.pkcs15.KeyAccessFlags;
import de.intarsys.security.smartcard.pkcs15.KeyUsageFlags;
import de.intarsys.tools.string.PrettyPrinter;
import java.text.ParseException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;

public class CommonKeyAttributes
extends ASN1Based {
    public static final Factory FACTORY = new Factory();
    private Identifier identifier;
    private KeyUsageFlags usage;

    public KeyAccessFlags getAccessFlags() {
        return (KeyAccessFlags)KeyAccessFlags.FACTORY.create((ASN1Encodable)this.getValueHolder().getNextTyped(3, DERBitString.class));
    }

    public ASN1Primitive getAlgReference() {
        ASN1TaggedHolder object = this.getValueHolder().getNextTagged(0, 1);
        if (object != null) {
            return object.getChild().toASN1Primitive();
        }
        return null;
    }

    public Date getEndDate() {
        ASN1ValueHolder object = this.getValueHolder().getNextTaggedGetChild(0, 0, false);
        if (object != null) {
            try {
                return ((ASN1GeneralizedTime)object.getValue()).getDate();
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public int getKeyReference() {
        ASN1ValueHolder object = this.getValueHolder().getNextTyped(2, ASN1Integer.class);
        if (object != null) {
            return object.toDERInteger().getValue().intValue();
        }
        return -1;
    }

    public Date getStartDate() {
        ASN1ValueHolder object = this.getValueHolder().getNextTyped(2, ASN1GeneralizedTime.class);
        if (object != null) {
            try {
                return ((ASN1GeneralizedTime)object.getValue()).getDate();
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public KeyUsageFlags getUsage() {
        return this.usage;
    }

    protected void initializeAfterCreate() {
        super.initializeAfterCreate();
        this.identifier = (Identifier)Identifier.FACTORY.create((ASN1Encodable)this.getValueHolder().getChild(0));
        this.usage = (KeyUsageFlags)KeyUsageFlags.FACTORY.create((ASN1Encodable)this.getValueHolder().getChild(1));
    }

    public boolean isNative() {
        ASN1ValueHolder nativeFlag = this.getValueHolder().getNextTyped(1, ASN1Boolean.class);
        if (nativeFlag != null) {
            return ((ASN1Boolean)nativeFlag.toASN1Primitive()).isTrue();
        }
        return true;
    }

    public void setAccessFlags(KeyAccessFlags flags) {
        this.getValueHolder().setChild(3, (ASN1Encodable)flags);
    }

    public void setIdentifier(Identifier id) {
        this.identifier = id;
        this.getValueHolder().setChild(0, (ASN1Encodable)id);
    }

    public void setKeyReference(int keyRef) {
        this.getValueHolder().setChild(4, (ASN1Encodable)new ASN1Integer((long)keyRef));
    }

    public void setNative(boolean nativeFlag) {
        this.getValueHolder().setChild(2, (ASN1Encodable)ASN1Boolean.getInstance((boolean)nativeFlag));
    }

    public void setUsage(KeyUsageFlags flags) {
        this.usage = flags;
        this.getValueHolder().setChild(1, (ASN1Encodable)flags);
    }

    public void toString(PrettyPrinter printer) {
        printer.appendMember("id", (Object)this.getIdentifier(), null);
        printer.appendMember("usage", (Object)this.getUsage(), null);
        printer.appendMember("native", (Object)this.isNative(), null);
        printer.appendMember("accessFlags", (Object)this.getAccessFlags(), null);
        printer.appendMember("keyReference", (Object)this.getKeyReference(), null);
        printer.appendMember("startDate", (Object)this.getStartDate(), null);
        printer.appendMember("endDate", (Object)this.getEndDate(), null);
        printer.appendMember("algReference", (Object)this.getAlgReference(), null);
    }

    static class Factory
    extends ASN1Based.Factory<CommonKeyAttributes> {
        Factory() {
        }
    }
}

