/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.security.smartcard.pkcs15.AccessControlRule;
import de.intarsys.security.smartcard.pkcs15.CommonObjectFlags;
import de.intarsys.security.smartcard.pkcs15.Identifier;
import de.intarsys.tools.string.PrettyPrinter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERUTF8String;

public class CommonObjectAttributes
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public List<AccessControlRule> getAccessControlRules() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTyped(0, ASN1Sequence.class);
        if (vh != null) {
            ArrayList<AccessControlRule> list = new ArrayList<AccessControlRule>();
            vh.forEach(child -> list.add((AccessControlRule)AccessControlRule.FACTORY.create((ASN1Encodable)child)));
            return list;
        }
        return null;
    }

    public Identifier getAuthId() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTyped(0, DEROctetString.class);
        if (vh != null) {
            return (Identifier)Identifier.FACTORY.create((ASN1Encodable)vh);
        }
        return null;
    }

    public CommonObjectFlags getFlags() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTyped(0, DERBitString.class);
        if (vh != null) {
            return (CommonObjectFlags)CommonObjectFlags.FACTORY.create((ASN1Encodable)vh);
        }
        return null;
    }

    public String getLabel() {
        ASN1ValueHolder label = this.getValueHolder().getNextTyped(0, DERUTF8String.class);
        if (label != null) {
            return label.toASN1UTF8String().getString();
        }
        return "";
    }

    public BigInteger getUserConsent() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTyped(0, ASN1Integer.class);
        if (vh != null) {
            return vh.toDERInteger().getValue();
        }
        return null;
    }

    public void setAuthId(Identifier authId) {
        this.getValueHolder().setChild(2, (ASN1Encodable)authId.toASN1Primitive());
    }

    public void setFlags(CommonObjectFlags flags) {
        this.getValueHolder().setChild(1, (ASN1Encodable)flags);
    }

    public void setLabel(String label) {
        this.getValueHolder().setChild(0, (ASN1Encodable)new DERUTF8String(label));
    }

    public void toString(PrettyPrinter printer) {
        printer.appendMember("label", (Object)this.getLabel(), null);
        printer.appendMember("flags", (Object)this.getFlags(), null);
        printer.appendMember("authId", (Object)this.getAuthId(), null);
        printer.appendMember("userConsent", (Object)this.getUserConsent(), null);
        printer.appendMember("accessControlRules", this.getAccessControlRules(), null);
    }

    static class Factory
    extends ASN1Based.Factory<CommonObjectAttributes> {
        Factory() {
        }
    }
}

