/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.tools.string.PrettyPrinter;

public class CommonObjectFlags
extends ASN1Based {
    public static final Factory FACTORY = new Factory();
    public static final int BIT_PRIVATE = 0;
    public static final int BIT_MODIFIABLE = 1;
    public static final int BIT_INTERNAL = 2;
    protected static final String[] FLAGS = new String[]{"private", "modifiable", "internal"};

    protected byte[] getValue() {
        return this.getValueHolder().toDERBitString().getBytes();
    }

    public boolean isInternal() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)2);
    }

    public boolean isModifiable() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)1);
    }

    public boolean isPrivate() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)0);
    }

    public void toString(PrettyPrinter printer) {
        ASN1Tools.printBitStringFlags((PrettyPrinter)printer, (byte[])this.getValue(), (String[])FLAGS);
    }

    public static class Factory
    extends ASN1Based.Factory<CommonObjectFlags> {
    }
}

