/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.ICardApplicationFactory;
import de.intarsys.security.smartcard.pkcs15.AuthenticationObject;
import de.intarsys.security.smartcard.pkcs15.CardInfo;
import de.intarsys.security.smartcard.pkcs15.IPkcs15StructureTransformer;
import de.intarsys.security.smartcard.pkcs15.IdentifierOctetString;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Structure;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;

public class DTrustV4Transformer
implements IPkcs15StructureTransformer {
    @Override
    public void transform(Pkcs15Structure pkcs15, ICardApplicationFactory factory, ICardConnection connection) {
        CardInfo tokenInfo = pkcs15.getP15TokenInfo();
        if (tokenInfo == null) {
            return;
        }
        String label = tokenInfo.getLabel();
        if (!Pattern.matches("(?i)(.*(d-sign)|(d-trust)).*(4\\.[14]).*", label)) {
            return;
        }
        AuthenticationObject authObject = pkcs15.getP15AuthenticationObjectDirectory().getObject(new byte[]{2});
        if (authObject != null) {
            IdentifierOctetString authId = (IdentifierOctetString)IdentifierOctetString.FACTORY.create((ASN1Encodable)new DEROctetString(new byte[]{7}));
            authObject.getCommonAuthenticationObjectAttributes().setAuthId(authId);
        }
    }
}

