/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.tools.string.PrettyPrinter;

public class KeyAccessFlags
extends ASN1Based {
    public static final Factory FACTORY = new Factory();
    public static final int BIT_SENSITIVE = 0;
    public static final int BIT_EXTRACTABLE = 1;
    public static final int BIT_ALWAYSSENSITIVE = 2;
    public static final int BIT_NEVEREXTRACTABLE = 3;
    public static final int BIT_LOCAL = 4;
    protected static final String[] FLAGS = new String[]{"sensitive", "extractable", "alwaysSensitive", "neverExtractable", "local"};

    protected byte[] getValue() {
        return this.getValueHolder().toDERBitString().getBytes();
    }

    public boolean isAlwayssensitive() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)2);
    }

    public boolean isExtractable() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)1);
    }

    public boolean isLocal() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)4);
    }

    public boolean isNeverextractable() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)3);
    }

    public boolean isSensitive() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)0);
    }

    public void toString(PrettyPrinter printer) {
        ASN1Tools.printBitStringFlags((PrettyPrinter)printer, (byte[])this.getValue(), (String[])FLAGS);
    }

    public static class Factory
    extends ASN1Based.Factory<KeyAccessFlags> {
    }
}

