/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.certificate.CertificateUsage;
import de.intarsys.tools.string.PrettyPrinter;

public class KeyUsageFlags
extends ASN1Based {
    public static final Factory FACTORY = new Factory();
    public static final int BIT_ENCRYPT = 0;
    public static final int BIT_DECRYPT = 1;
    public static final int BIT_SIGN = 2;
    public static final int BIT_SIGN_RECOVER = 3;
    public static final int BIT_WRAP = 4;
    public static final int BIT_UNWRAP = 5;
    public static final int BIT_VERIFY = 6;
    public static final int BIT_VERIFY_RECOVER = 7;
    public static final int BIT_DERIVE = 8;
    public static final int BIT_NON_REPUDIATION = 9;
    protected static final String[] FLAGS = new String[]{"encrypt", "decrypt", "sign", "signRecover", "wrap", "unwrap", "verify", "verifyRecover", "derive", "nonRepudiation"};

    protected byte[] getValue() {
        return this.getValueHolder().toDERBitString().getBytes();
    }

    public boolean isDecrypt() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)1);
    }

    public boolean isDerive() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)8);
    }

    public boolean isEncrypt() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)0);
    }

    public boolean isNonRepudiation() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)9);
    }

    public boolean isSign() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)2);
    }

    public boolean isSignRecover() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)3);
    }

    public boolean isUnwrap() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)5);
    }

    public boolean isVerify() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)6);
    }

    public boolean isVerifyRecover() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)7);
    }

    public boolean isWrap() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)4);
    }

    public CertificateUsage toCertificateUsage() {
        boolean digitalSignature = this.isSign() || this.isSignRecover();
        boolean nonRepudiation = this.isNonRepudiation();
        boolean keyEncipherment = this.isUnwrap();
        boolean dataEncipherment = this.isDecrypt();
        return new CertificateUsage(digitalSignature, nonRepudiation, keyEncipherment, dataEncipherment, new String[0]);
    }

    public void toString(PrettyPrinter printer) {
        ASN1Tools.printBitStringFlags((PrettyPrinter)printer, (byte[])this.getValue(), (String[])FLAGS);
    }

    public static class Factory
    extends ASN1Based.Factory<KeyUsageFlags> {
    }
}

