/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.pkcs15.Identifier;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Object;
import de.intarsys.tools.string.PrettyPrinter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ObjectDirectory<T extends Pkcs15Object> {
    private final List<T> elements;
    private CardFileSelector path;

    public ObjectDirectory() {
        this(null, Collections.emptyList());
    }

    public ObjectDirectory(CardFileSelector path) {
        this(path, Collections.emptyList());
    }

    public ObjectDirectory(CardFileSelector path, List<T> elements) {
        this.path = path;
        this.elements = elements;
    }

    public boolean contains(Identifier id) {
        return this.getObject(id) != null;
    }

    public T getObject(byte[] id) {
        for (int i = 0; i < this.size(); ++i) {
            T ao = this.getObject(i);
            if (!Arrays.equals(((Pkcs15Object)((Object)ao)).getIdentifier().getByteValue(), id)) continue;
            return ao;
        }
        return null;
    }

    public T getObject(Identifier objectId) {
        for (int i = 0; i < this.size(); ++i) {
            T ao = this.getObject(i);
            if (!((Pkcs15Object)((Object)ao)).getIdentifier().equals((Object)objectId)) continue;
            return ao;
        }
        return null;
    }

    public T getObject(int index) {
        if (index < this.elements.size()) {
            return (T)((Object)((Pkcs15Object)((Object)this.elements.get(index))));
        }
        return null;
    }

    public List<T> getObjects() {
        return new ArrayList<T>(this.elements);
    }

    public CardFileSelector getPath() {
        return this.path;
    }

    public int size() {
        return this.elements.size();
    }

    public final String toString() {
        PrettyPrinter printer = new PrettyPrinter();
        printer.appendMember("path", (Object)this.getPath(), null);
        printer.appendMember("elements", this.elements, null);
        return printer.toString();
    }
}

