/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.pkcs15.PathOrObjects;
import de.intarsys.tools.string.PrettyPrinter;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;

public class ObjectDirectoryFile {
    private PathOrObjects authenticationObjects;
    private PathOrObjects certificateObjects;
    private PathOrObjects dataObjects;
    private PathOrObjects privateKeyObjects;
    private PathOrObjects publicKeyObjects;
    private PathOrObjects secretKeyObjects;
    private PathOrObjects trustedCertificateObjects;
    private PathOrObjects trustedPublicKeyObjects;
    private PathOrObjects usefulCertificateObjects;

    public ObjectDirectoryFile(List<ASN1Primitive> elements) {
        this.createDirectory(elements);
    }

    protected void createDirectory(List<ASN1Primitive> elements) {
        for (ASN1Primitive element : elements) {
            ASN1TaggedObject tagged = ASN1TaggedObject.getInstance((Object)element);
            if (tagged == null) continue;
            this.createTaggedObject(tagged);
        }
    }

    protected void createTaggedObject(ASN1TaggedObject tagged) {
        ASN1Sequence sequence = ASN1Sequence.getInstance((ASN1TaggedObject)tagged, (boolean)true);
        PathOrObjects pathOrObj = (PathOrObjects)PathOrObjects.FACTORY.create((ASN1Encodable)sequence);
        switch (tagged.getTagNo()) {
            case 0: {
                this.setPrivateKeyObjects(pathOrObj);
                break;
            }
            case 1: {
                this.setPublicKeyObjects(pathOrObj);
                break;
            }
            case 2: {
                this.setTrustedPublicKeyObjects(pathOrObj);
                break;
            }
            case 3: {
                this.setSecretKeyObjects(pathOrObj);
                break;
            }
            case 4: {
                this.setCertificateObjects(pathOrObj);
                break;
            }
            case 5: {
                this.setTrustedCertificateObjects(pathOrObj);
                break;
            }
            case 6: {
                this.setUsefulCertificateObjects(pathOrObj);
                break;
            }
            case 7: {
                this.setDataObjects(pathOrObj);
                break;
            }
            case 8: {
                this.setAuthenticationObjects(pathOrObj);
                break;
            }
        }
    }

    public PathOrObjects getAuthenticationObjects() {
        return this.authenticationObjects;
    }

    public CardFileSelector getAuthenticationObjectsDirectoryPath() {
        return this.toCardFileSelector(this.getAuthenticationObjects());
    }

    public PathOrObjects getCertificateObjects() {
        return this.certificateObjects;
    }

    public CardFileSelector getCertificateObjectsDirectoryPath() {
        return this.toCardFileSelector(this.getCertificateObjects());
    }

    public PathOrObjects getDataObjects() {
        return this.dataObjects;
    }

    public CardFileSelector getDataObjectsDirectoryPath() {
        return this.toCardFileSelector(this.getDataObjects());
    }

    public PathOrObjects getPrivateKeyObjects() {
        return this.privateKeyObjects;
    }

    public CardFileSelector getPrivateKeyObjectsDirectoryPath() {
        return this.toCardFileSelector(this.getPrivateKeyObjects());
    }

    public PathOrObjects getPublicKeyObjects() {
        return this.publicKeyObjects;
    }

    public CardFileSelector getPublicKeyObjectsDirectoryPath() {
        return this.toCardFileSelector(this.getPublicKeyObjects());
    }

    public PathOrObjects getSecretKeyObjects() {
        return this.secretKeyObjects;
    }

    public CardFileSelector getSecretKeyObjectsDirectoryPath() {
        return this.toCardFileSelector(this.getSecretKeyObjects());
    }

    public PathOrObjects getTrustedCertificateObjects() {
        return this.trustedCertificateObjects;
    }

    public CardFileSelector getTrustedCertificateObjectsDirectoryPath() {
        return this.toCardFileSelector(this.getTrustedCertificateObjects());
    }

    public PathOrObjects getTrustedPublicKeyObjects() {
        return this.trustedPublicKeyObjects;
    }

    public CardFileSelector getTrustedPublicKeyObjectsDirectoryPath() {
        return this.toCardFileSelector(this.getTrustedPublicKeyObjects());
    }

    public PathOrObjects getUsefulCertificateObjects() {
        return this.usefulCertificateObjects;
    }

    public CardFileSelector getUsefulCertificateObjectsDirectoryPath() {
        return this.toCardFileSelector(this.getUsefulCertificateObjects());
    }

    protected void setAuthenticationObjects(PathOrObjects authObjects) {
        this.authenticationObjects = authObjects;
    }

    protected void setCertificateObjects(PathOrObjects certificates) {
        this.certificateObjects = certificates;
    }

    protected void setDataObjects(PathOrObjects dataObjects) {
        this.dataObjects = dataObjects;
    }

    protected void setPrivateKeyObjects(PathOrObjects privateKeys) {
        this.privateKeyObjects = privateKeys;
    }

    protected void setPublicKeyObjects(PathOrObjects publicKeys) {
        this.publicKeyObjects = publicKeys;
    }

    protected void setSecretKeyObjects(PathOrObjects secretKeys) {
        this.secretKeyObjects = secretKeys;
    }

    protected void setTrustedCertificateObjects(PathOrObjects trustedCertificates) {
        this.trustedCertificateObjects = trustedCertificates;
    }

    protected void setTrustedPublicKeyObjects(PathOrObjects trustedPrivateKeys) {
        this.trustedPublicKeyObjects = trustedPrivateKeys;
    }

    protected void setUsefulCertificateObjects(PathOrObjects usefulCertificates) {
        this.usefulCertificateObjects = usefulCertificates;
    }

    private CardFileSelector toCardFileSelector(PathOrObjects pathOrObjects) {
        if (pathOrObjects == null) {
            return null;
        }
        if (pathOrObjects.getPath() == null) {
            throw new IllegalStateException("A 'PathOrObject' not referenced by a 'Path' object is not supported yet");
        }
        return pathOrObjects.getPath().toCardFileSelector();
    }

    public final String toString() {
        try {
            PrettyPrinter printer = new PrettyPrinter();
            printer.appendMember("authenticationObjects", (Object)this.authenticationObjects, null);
            printer.appendMember("certificateObjects", (Object)this.certificateObjects, null);
            printer.appendMember("dataObjects", (Object)this.dataObjects, null);
            printer.appendMember("privateKeyObjects", (Object)this.privateKeyObjects, null);
            printer.appendMember("publicKeyObjects", (Object)this.publicKeyObjects, null);
            printer.appendMember("secretKeyObjects", (Object)this.secretKeyObjects, null);
            printer.appendMember("trustedCertificateObjects", (Object)this.trustedCertificateObjects, null);
            printer.appendMember("trustedPublicKeyObjects", (Object)this.trustedPublicKeyObjects, null);
            printer.appendMember("usefulCertificateObjects", (Object)this.usefulCertificateObjects, null);
            return printer.toString();
        }
        catch (Exception e) {
            return "<error>";
        }
    }
}

