/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.security.smartcard.pkcs15.PasswordFlags;
import de.intarsys.security.smartcard.pkcs15.PasswordType;
import de.intarsys.security.smartcard.pkcs15.Path;
import de.intarsys.tools.string.PrettyPrinter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;

public class PasswordAttributes
extends ASN1Based {
    public static final Factory FACTORY = new Factory();
    private PasswordFlags pwdFlags;
    private PasswordType pwdType;
    private Path path;

    public String getLastPasswordChange() {
        ASN1ValueHolder o = this.getValueHolder().getNextTyped(4, ASN1GeneralizedTime.class);
        if (o != null) {
            return ((ASN1GeneralizedTime)o.toASN1Primitive()).getTime();
        }
        return null;
    }

    public Integer getMaxLength() {
        ASN1ValueHolder o = this.getValueHolder().getNextTyped(4, ASN1Integer.class);
        if (o != null) {
            int max = o.toDERInteger().getPositiveValue().intValue();
            return max;
        }
        return null;
    }

    public Integer getMinLength() {
        ASN1ValueHolder vh = this.getValueHolder().getChild(2);
        if (vh == null) {
            return 0;
        }
        ASN1Integer derInt = vh.toDERInteger();
        if (derInt != null) {
            return derInt.getValue().intValue();
        }
        return null;
    }

    public byte[] getPadBytes() {
        ASN1ValueHolder o = this.getValueHolder().getNextTyped(4, DEROctetString.class);
        if (o != null) {
            return o.toDEROctetString().getOctets();
        }
        return null;
    }

    public Path getPath() {
        return this.path;
    }

    public PasswordFlags getPwdFlags() {
        return this.pwdFlags;
    }

    public Integer getPwdReference() {
        ASN1ValueHolder o = this.getValueHolder().getNextTaggedGetChild(0, 0, false);
        if (o != null) {
            ASN1Integer derInt = o.toDERInteger();
            return derInt.getPositiveValue().intValue();
        }
        return 0;
    }

    public PasswordType getPwdType() {
        return this.pwdType;
    }

    public Integer getStoredLength() {
        ASN1ValueHolder vh = this.getValueHolder().getChild(3);
        if (vh == null) {
            return 0;
        }
        ASN1Integer derInt = vh.toDERInteger();
        if (derInt != null) {
            return derInt.getValue().intValue();
        }
        return null;
    }

    protected void initializeAfterCreate() {
        super.initializeAfterCreate();
        this.pwdFlags = (PasswordFlags)PasswordFlags.FACTORY.create((ASN1Encodable)this.getValueHolder().getChild(0));
        this.pwdType = (PasswordType)PasswordType.FACTORY.create((ASN1Encodable)this.getValueHolder().getChild(1));
        ASN1ValueHolder o = this.getValueHolder().getNextTyped(4, ASN1Sequence.class);
        if (o != null) {
            this.path = (Path)Path.FACTORY.create((ASN1Encodable)o);
        }
    }

    public boolean isValid() {
        return this.getValueHolder().size() >= 4;
    }

    public void toString(PrettyPrinter printer) {
        printer.appendMember("pwdFlags", (Object)this.getPwdFlags(), null);
        printer.appendMember("pwdType", (Object)this.getPwdType(), null);
        printer.appendMember("minLength", (Object)this.getMinLength(), null);
        printer.appendMember("storedLength", (Object)this.getStoredLength(), null);
        printer.appendMember("maxLength", (Object)this.getMaxLength(), null);
        printer.appendMember("pwdReference", (Object)this.getPwdReference(), null);
        printer.appendMember("padChar", (Object)this.getPadBytes(), null);
        printer.appendMember("lastPasswordChange", (Object)this.getLastPasswordChange(), null);
        printer.appendMember("path", (Object)this.getPath(), null);
    }

    static class Factory
    extends ASN1Based.Factory<PasswordAttributes> {
        Factory() {
        }
    }
}

