/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.tools.string.PrettyPrinter;

public class PasswordFlags
extends ASN1Based {
    public static final Factory FACTORY = new Factory();
    public static final int BIT_CASE_SENSITIVE = 1;
    public static final int BIT_LOCAL = 1;
    public static final int BIT_CHANGE_DISABLED = 2;
    public static final int BIT_UNBLOCK_DISABLED = 3;
    public static final int BIT_INITIALIZED = 4;
    public static final int BIT_NEEDS_PADDING = 5;
    public static final int BIT_UNBLOCKING_PIN = 6;
    public static final int BIT_SO_PIN = 7;
    public static final int BIT_DISABLE_ALLOWED = 8;
    public static final int BIT_INTEGRITY_PROTECTED = 9;
    public static final int BIT_CONFIDENTIALITY_PROTECTED = 10;
    public static final int BIT_EXCHANGE_REF_DATA = 11;
    protected static final String[] FLAGS = new String[]{"case-sensitive", "local", "change-disabled", "unblock-disabled", "initialized", "needs-padding", "unblockingPin", "soPin", "disable-allowed", "integrity-protected", "confidentiality-protected", "exchangeRefData"};

    protected byte[] getValue() {
        return this.getValueHolder().toDERBitString().getBytes();
    }

    public boolean isCaseSensitive() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)1);
    }

    public boolean isChangeDisabled() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)2);
    }

    public boolean isConfidentialityProtected() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)10);
    }

    public boolean isDisableAllowed() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)8);
    }

    public boolean isExchangeRefData() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)11);
    }

    public boolean isInitialized() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)4);
    }

    public boolean isIntegrityProtected() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)9);
    }

    public boolean isLocal() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)1);
    }

    public boolean isNeedsPadding() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)5);
    }

    public boolean isSoPin() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)7);
    }

    public boolean isUnblockDisabled() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)3);
    }

    public boolean isUnblockingPin() {
        return ASN1Tools.getBitStringValue((byte[])this.getValue(), (int)6);
    }

    public void toString(PrettyPrinter printer) {
        ASN1Tools.printBitStringFlags((PrettyPrinter)printer, (byte[])this.getValue(), (String[])FLAGS);
    }

    static class Factory
    extends ASN1Based.Factory<PasswordFlags> {
        Factory() {
        }
    }
}

