/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.tools.string.PrettyPrinter;

public class PasswordType
extends ASN1Based {
    public static final Factory FACTORY = new Factory();
    public static final int PIN_TYPE_ASCII_NUMERIC = 1;
    public static final int PIN_TYPE_BCD = 0;
    public static final int PIN_TYPE_HALFNIBBLE_BCD = 3;
    public static final int PIN_TYPE_ISO9564_1 = 4;
    public static final int PIN_TYPE_UTF8 = 2;

    public int getValue() {
        return this.getValueHolder().toDEREnumerated().getValue().intValue();
    }

    public boolean isAsciiNumeric() {
        return this.getValue() == 1;
    }

    public boolean isBCD() {
        return this.getValue() == 0;
    }

    public boolean isHalfnibbleBCD() {
        return this.getValue() == 3;
    }

    public boolean isISO9564p1() {
        return this.getValue() == 4;
    }

    public boolean isUTF8() {
        return this.getValue() == 2;
    }

    public void toString(PrettyPrinter printer) {
        switch (this.getValue()) {
            case 1: {
                printer.appendValue((Object)"ASCII-Numeric");
                break;
            }
            case 0: {
                printer.appendValue((Object)"BCD");
                break;
            }
            case 3: {
                printer.appendValue((Object)"Halfnibble BCD");
                break;
            }
            case 4: {
                printer.appendValue((Object)"ISO9564-1");
                break;
            }
            case 2: {
                printer.appendValue((Object)"UTF8");
                break;
            }
            default: {
                printer.appendValue((Object)("unknown(" + this.getValue() + ")"));
            }
        }
    }

    static class Factory
    extends ASN1Based.Factory<PasswordType> {
        Factory() {
        }
    }
}

