/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1SequenceHolder;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.security.smartcard.app.filesystem.CardFileName;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.CardNamedPath;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.string.PrettyPrinter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DEROctetString;

public class Path
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public AppFileRef getAppFileRef() {
        ASN1ValueHolder o = this.getValueHolder().getChild(0);
        if (o.isTagged() && ((ASN1TaggedHolder)o).getTagNo() == 1) {
            ASN1SequenceHolder seq = (ASN1SequenceHolder)o.getChild();
            AppFileRef result = new AppFileRef();
            result.aid = seq.getChild(0).getChild().toBytes();
            result.path = seq.getChild(1).toDEROctetString().getOctets();
            return result;
        }
        return null;
    }

    public int getIndex() {
        ASN1ValueHolder object = this.getValueHolder().getNextTyped(0, ASN1Integer.class);
        if (object != null) {
            return object.toDERInteger().getValue().intValue();
        }
        return 0;
    }

    public int getLength() {
        ASN1ValueHolder object = this.getValueHolder().getNextTaggedGetChild(0, 0, false);
        if (object != null) {
            return object.toDERInteger().getValue().intValue();
        }
        return 0;
    }

    public byte[] getPathString() {
        ASN1ValueHolder o = this.getValueHolder().getChild(0);
        if (o != null) {
            return o.toDEROctetString().getOctets();
        }
        return null;
    }

    public boolean isAppFileRef() {
        ASN1ValueHolder o = this.getValueHolder().getChild(0);
        if (o.isTagged()) {
            return ((ASN1TaggedHolder)o).getTagNo() == 1;
        }
        return false;
    }

    public boolean isAppTagRef() {
        ASN1ValueHolder o = this.getValueHolder().getChild(0);
        if (o.isTagged()) {
            return ((ASN1TaggedHolder)o).getTagNo() == 2;
        }
        return false;
    }

    public boolean isPath() {
        ASN1ValueHolder o = this.getValueHolder().getChild(0);
        return !o.isTagged();
    }

    public boolean isTagRef() {
        ASN1ValueHolder o = this.getValueHolder().getChild(0);
        if (o.isTagged()) {
            return ((ASN1TaggedHolder)o).getTagNo() == 0;
        }
        return false;
    }

    public void setPathString(byte[] pathString) {
        this.getValueHolder().setChild(0, (ASN1Encodable)new DEROctetString(pathString));
    }

    public CardFileSelector toCardFileSelector() {
        if (this.isPath()) {
            byte[] path = this.getPathString();
            if (path == null || path.length == 0) {
                return null;
            }
            return new CardFilePath(path);
        }
        if (this.isAppFileRef()) {
            AppFileRef appFileRef = this.getAppFileRef();
            return new CardNamedPath(new CardFileName(appFileRef.aid), new CardFilePath(appFileRef.path));
        }
        return null;
    }

    public void toString(PrettyPrinter printer) {
        if (this.isPath()) {
            printer.appendMember("path", (Object)this.getPathString(), null);
        } else if (this.isAppFileRef()) {
            printer.appendMember("appFileRef", (Object)this.getAppFileRef(), null);
        }
        printer.appendMember("index", (Object)this.getIndex(), null);
        printer.appendMember("length", (Object)this.getLength(), null);
    }

    public static class AppFileRef {
        public byte[] aid;
        public byte[] path;

        public String toString() {
            return HexTools.bytesToHexString((byte[])this.aid) + "/" + HexTools.bytesToHexString((byte[])this.path);
        }
    }

    public static class Factory
    extends ASN1Based.Factory<Path> {
    }
}

