/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.security.smartcard.pkcs15.CommonObjectAttributes;
import de.intarsys.security.smartcard.pkcs15.CommonObjectFlags;
import de.intarsys.security.smartcard.pkcs15.Identifier;
import de.intarsys.tools.string.PrettyPrinter;
import org.bouncycastle.asn1.ASN1Encodable;

public abstract class Pkcs15Object
extends ASN1Based {
    protected Pkcs15Object() {
    }

    protected ASN1ValueHolder baseGetClassAttributes() {
        return this.getValueHolder().getChild(1);
    }

    protected ASN1ValueHolder baseGetSubClassAttributes() {
        return this.getValueHolder().getNextTaggedGetChild(2, 0, true);
    }

    protected ASN1ValueHolder baseGetTypeAttributes() {
        return this.getValueHolder().getNextTaggedGetChild(2, 1, true);
    }

    protected void baseSetClassAttributes(ASN1ValueHolder valueHolder) {
        this.getValueHolder().setChild(1, (ASN1Encodable)valueHolder);
    }

    protected void baseSetTypeAttributes(ASN1ValueHolder valueHolder) {
        this.getValueHolder().setChild(2, (ASN1Encodable)new ASN1TaggedHolder(true, 1, (ASN1Encodable)valueHolder));
    }

    public Identifier getAuthId() {
        return this.getCommonObjectAttributes().getAuthId();
    }

    public abstract ASN1Based getClassAttributes();

    public CommonObjectAttributes getCommonObjectAttributes() {
        return (CommonObjectAttributes)CommonObjectAttributes.FACTORY.create((ASN1Encodable)this.getValueHolder().getChild(0));
    }

    public CommonObjectFlags getFlags() {
        return this.getCommonObjectAttributes().getFlags();
    }

    public abstract Identifier getIdentifier();

    public String getLabel() {
        return this.getCommonObjectAttributes().getLabel();
    }

    public abstract ASN1Based getSubClassAttributes();

    public abstract ASN1Based getTypeAttributes();

    protected void initializeAfterCreateNew() {
        super.initializeAfterCreateNew();
        this.getValueHolder().setChild(0, (ASN1Encodable)((CommonObjectAttributes)CommonObjectAttributes.FACTORY.createNew()).getValueHolder());
    }

    public boolean isValid() {
        return true;
    }

    public void toString(PrettyPrinter printer) {
        printer.appendMember("commonObjectAttributes", (Object)this.getCommonObjectAttributes(), null);
        printer.appendMember("classAttributes", (Object)this.getClassAttributes(), null);
        printer.appendMember("subClassAttributes", (Object)this.getSubClassAttributes(), null);
        printer.appendMember("typeAttributes", (Object)this.getTypeAttributes(), null);
    }

    public static class Factory<T extends Pkcs15Object>
    extends ASN1Based.Factory<T> {
    }
}

