/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.certificate.CertificateUsage;
import de.intarsys.security.certificate.filter.ICertificateUsageFilter;
import de.intarsys.security.smartcard.app.filesystem.CardFileInfo;
import de.intarsys.security.smartcard.app.filesystem.CardFileName;
import de.intarsys.security.smartcard.app.filesystem.CardFileNotFoundException;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.CardFileTools;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.common.CommonPinCodec;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.security.smartcard.common.PinCodecAscii;
import de.intarsys.security.smartcard.common.PinCodecBcd;
import de.intarsys.security.smartcard.common.PinCodecFormat2;
import de.intarsys.security.smartcard.model.CardCertificateInfo;
import de.intarsys.security.smartcard.model.ICardApplicationFactory;
import de.intarsys.security.smartcard.model.ICardCertificateInfo;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.PinInfo;
import de.intarsys.security.smartcard.model.PrivateKeyInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationCardReset;
import de.intarsys.security.smartcard.model.app.CardApplicationCardUnavailable;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.pkcs15.AbstractKeyAttributesRSA;
import de.intarsys.security.smartcard.pkcs15.AuthenticationObject;
import de.intarsys.security.smartcard.pkcs15.AuthenticationObjectPassword;
import de.intarsys.security.smartcard.pkcs15.CardInfo;
import de.intarsys.security.smartcard.pkcs15.CertificateObject;
import de.intarsys.security.smartcard.pkcs15.DTrustV4Transformer;
import de.intarsys.security.smartcard.pkcs15.IPkcs15StructureTransformer;
import de.intarsys.security.smartcard.pkcs15.Identifier;
import de.intarsys.security.smartcard.pkcs15.KeyObject;
import de.intarsys.security.smartcard.pkcs15.KeyUsageFlags;
import de.intarsys.security.smartcard.pkcs15.ObjectDirectory;
import de.intarsys.security.smartcard.pkcs15.ObjectDirectoryFile;
import de.intarsys.security.smartcard.pkcs15.PACKAGE;
import de.intarsys.security.smartcard.pkcs15.PKCS15Tools;
import de.intarsys.security.smartcard.pkcs15.PasswordAttributes;
import de.intarsys.security.smartcard.pkcs15.PasswordType;
import de.intarsys.security.smartcard.pkcs15.Path;
import de.intarsys.security.smartcard.pkcs15.Pkcs15CardHolderCertificateInfo;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Object;
import de.intarsys.security.smartcard.pkcs15.PrivateKeyObject;
import de.intarsys.security.smartcard.pkcs15.PrivateKeyObjectRSA;
import de.intarsys.security.smartcard.pkcs15.PublicKeyObject;
import de.intarsys.security.smartcard.pkcs15.ReferencedValue;
import de.intarsys.security.smartcard.pkcs15.SecurityEnvironmentInfo;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.message.IMessageBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class Pkcs15Structure {
    private static final List<IPkcs15StructureTransformer> Transformers = new ArrayList<IPkcs15StructureTransformer>();
    public static final String PREFIX_PIN = "PIN.";
    public static final String PREFIX_CERT = "Cert.";
    private static final IMessageBundle Msg;
    private static final Logger Log;
    public static final CardFileName PKCS15_AID;
    public static final String FID_ODF = "5031";
    public static final String FID_TOKEN_INFO = "5032";
    public static final String FID_UNUSED_SPACE = "5033";
    protected static final byte[] PKCS15_STRING;
    protected static final byte[] RID;
    protected static final byte[] ISO_AID_PREFIX;
    private final CardFilePath odfFilePath = new CardFilePath("5031");
    private final CardFilePath tokenInfoPath = new CardFilePath("5032");
    private CardInfo p15TokenInfo;
    private ObjectDirectory<AuthenticationObject> p15AuthenticationObjectDirectory;
    private ObjectDirectory<CertificateObject> p15CertificateObjectDirectory;
    private ObjectDirectoryFile p15ObjectDirectoryFile;
    private ObjectDirectory<PrivateKeyObject> p15PrivateKeyObjectDirectory;
    private ObjectDirectory<PublicKeyObject> p15PublicKeyObjectDirectory;
    private ObjectDirectory<CertificateObject> p15TrustedCertificateObjectDirectory;
    private final List<Pkcs15CardHolderCertificateInfo> cardHolderCertificateInfos;
    private final Map<String, PinInfo> pinInfos;
    private final List<ICardCertificateInfo> caCertificateInfos;
    private final List<ICardCertificateInfo> trustedCertificateInfos;
    private CardFileSelector applicationAID;
    private CardFileSelector pkcs15AID = PKCS15_AID;
    private IMessageBundle messageBundle;

    protected static String createIdentifier(String prefix, Identifier identifier) {
        if (identifier == null) {
            return null;
        }
        return prefix + "@" + HexTools.bytesToHexString((byte[])identifier.getByteValue());
    }

    public static Pkcs15Structure getPkcs15(ICardApplicationFactory factory, ICardConnection connection, CardFileSelector pkcs15AID, CardFileSelector applicationAID) throws CardApplicationException {
        String attributeName = "pkcs15-" + (pkcs15AID == null ? "null" : pkcs15AID.toString());
        Object attribute = connection.getCard().getAttribute((Object)attributeName);
        if (attribute instanceof Pkcs15Structure) {
            return (Pkcs15Structure)attribute;
        }
        if (attribute instanceof CardApplicationException) {
            throw (CardApplicationException)attribute;
        }
        Pkcs15Structure pkcs15 = new Pkcs15Structure();
        if (pkcs15AID != null) {
            pkcs15.setPKCS15AID(pkcs15AID);
        }
        if (applicationAID != null) {
            pkcs15.setApplicationAID(applicationAID);
        }
        try {
            pkcs15.initialize(factory, connection);
            connection.getCard().setAttribute((Object)attributeName, (Object)pkcs15);
            return pkcs15;
        }
        catch (CardApplicationCardReset e) {
            throw e;
        }
        catch (CardApplicationCardUnavailable e) {
            throw e;
        }
        catch (CardFileNotFoundException e) {
            connection.getCard().setAttribute((Object)attributeName, (Object)e);
            throw e;
        }
        catch (CardApplicationException e) {
            Log.info("error reading PKCS15 application", (Throwable)e);
            connection.getCard().setAttribute((Object)attributeName, (Object)e);
            throw e;
        }
    }

    public Pkcs15Structure() {
        this.cardHolderCertificateInfos = new ArrayList<Pkcs15CardHolderCertificateInfo>(3);
        this.pinInfos = new HashMap<String, PinInfo>(10);
        this.caCertificateInfos = new ArrayList<ICardCertificateInfo>(3);
        this.trustedCertificateInfos = new ArrayList<ICardCertificateInfo>(3);
    }

    protected void addCaCertificate(IFileSystemApplication fileSystem, CertificateObject certObject) {
        this.caCertificateInfos.add(this.createCaCertificateInfo(fileSystem, certObject));
    }

    protected void addCardHolderCertificateInfo(IFileSystemApplication fileSystem, CertificateObject certObject, ICardCertificateInfo[] caChain) {
        this.cardHolderCertificateInfos.add(this.createCardHolderCertificateInfo(fileSystem, certObject, caChain));
    }

    protected void addTrustedCertificate(IFileSystemApplication fileSystem, CertificateObject certObject) {
        this.trustedCertificateInfos.add(this.createCaCertificateInfo(fileSystem, certObject));
    }

    protected ICardCertificateInfo createCaCertificateInfo(IFileSystemApplication fileSystem, CertificateObject certObject) {
        CardFileSelector certPath = CardFileTools.resolve(this.getApplicationPath(), certObject.getCardFileSelector());
        return new CardCertificateInfo(null, certPath, CertificateUsage.CA);
    }

    protected Pkcs15CardHolderCertificateInfo createCardHolderCertificateInfo(IFileSystemApplication fileSystem, CertificateObject certObject, ICardCertificateInfo[] caChain) {
        Identifier certId = certObject.getIdentifier();
        CardFileSelector certPath = CardFileTools.resolve(this.getApplicationPath(), certObject.getCardFileSelector());
        CardFileSelector privateKeyFile = this.getPrivateKeyFilePath(fileSystem, certId);
        CardFileSelector privateKeyDir = privateKeyFile == null ? null : privateKeyFile.getParent();
        PrivateKeyObject pkObject = this.getP15PrivateKeyObjectDirectory().getObject(certId);
        int privateKeyReference = pkObject.getKeyReference();
        String encryptionAlgorithmName = pkObject.isRSA() ? "RSA" : "ECDSA";
        PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(null, privateKeyDir, new byte[]{(byte)privateKeyReference}, encryptionAlgorithmName, new ArrayList<IMechanism>());
        CertificateUsage certificateUsage = this.getCertificateUsage(certObject);
        String pinId = Pkcs15Structure.createIdentifier(PREFIX_PIN, this.getAuthId(certId));
        PinInfo pinInfo = this.lookupPinInfo(pinId);
        if (pinInfo != null) {
            pinInfo.setHidden(false);
            if (pinInfo.getResettingPinInfo() != null) {
                ((PinInfo)pinInfo.getResettingPinInfo()).setHidden(false);
            }
        }
        return new Pkcs15CardHolderCertificateInfo(Pkcs15Structure.createIdentifier(PREFIX_CERT, certId), certId, certPath, certificateUsage, privateKeyInfo, pinInfo, null, caChain);
    }

    protected <T extends Pkcs15Object> ObjectDirectory<T> createObjectDirectory(CardFileSelector path, Pkcs15Object.Factory<T> factory, List<ASN1Primitive> elements) {
        return new ObjectDirectory<T>(path, this.subtypeElements(elements, factory));
    }

    private PinInfo createPinInfo(AuthenticationObjectPassword pinObject) {
        String pinIdentifier = Pkcs15Structure.createIdentifier(PREFIX_PIN, pinObject.getIdentifier());
        PasswordAttributes pinAttr = pinObject.getPinAttributes();
        PinInfo pinInfo = new PinInfo(pinIdentifier, pinAttr.getPwdReference(), this.getPinCodec(pinAttr), this.getCredentialPath(pinAttr));
        pinInfo.setLabel(pinObject.getLabel());
        Log.debug("pkcs#15 create PinInfo id {}, label {}, path {}, ref 0x{}", new Object[]{pinInfo.getId(), pinInfo.getLabel(), pinInfo.getDirectory(), Integer.toHexString(pinInfo.getReference())});
        return pinInfo;
    }

    private CardFilePath createSymbolicFile(byte[] identifier) {
        int size = 2;
        if (size > identifier.length) {
            size = identifier.length;
        }
        byte id = (byte)(ByteArrayTools.toLittleEndianInt((byte[])identifier, (int)0, (int)size) & 0xFF);
        return new CardFilePath(new byte[]{0, id});
    }

    protected void deriveApplicationAID() {
        if (!(this.getPKCS15AID() instanceof CardFileName)) {
            return;
        }
        if (!ByteArrayTools.startsWith((byte[])((CardFileName)this.getPKCS15AID()).getBytes(), (byte[])ISO_AID_PREFIX)) {
            return;
        }
        for (SecurityEnvironmentInfo info : this.p15TokenInfo.getSecurityEnvironmentInfo()) {
            if (info.getAid() == null) continue;
            this.deriveApplicationAID(new CardFileName(info.getAid()));
            break;
        }
        if (this.getApplicationAID() == null) {
            this.deriveApplicationAID(this.getPKCS15AID());
        }
    }

    protected void deriveApplicationAID(CardFileSelector aid) {
        if (!(aid instanceof CardFileName)) {
            return;
        }
        this.setApplicationAID(aid);
    }

    protected void dump() {
        Pkcs15Object obj;
        int i;
        if (!Log.isEnabledForLevel(Level.TRACE)) {
            return;
        }
        Log.trace("ObjectDirectoryFile");
        Log.trace(this.getP15ObjectDirectoryFile().toString());
        for (i = 0; i < this.getP15CertificateObjectDirectory().size(); ++i) {
            CertificateObject certObject = this.getP15CertificateObjectDirectory().getObject(i);
            Identifier certId = certObject.getIdentifier();
            String certIdHex = Pkcs15Structure.createIdentifier(PREFIX_CERT, certId);
            CertificateUsage usage = this.getCertificateUsage(certObject);
            Identifier authId = this.getAuthId(certId);
            String authIdHex = Pkcs15Structure.createIdentifier(PREFIX_PIN, authId);
            PinInfo pinInfo = this.lookupPinInfo(authIdHex);
            Log.trace("pkcs#15 Cert id {}, usage {}", (Object)certIdHex, (Object)usage);
            if (pinInfo == null) continue;
            Log.trace("pkcs#15 - PIN id {}, PIN path {}, PIN ref {}", new Object[]{pinInfo.getId(), pinInfo.getDirectory(), Integer.toHexString(pinInfo.getReference())});
            IPinInfo resetPinInfo = pinInfo.getResettingPinInfo();
            if (resetPinInfo == null) continue;
            Log.trace("pkcs#15 - reset PIN id {}, PIN path {}, PIN ref {}", new Object[]{resetPinInfo.getId(), resetPinInfo.getDirectory(), Integer.toHexString(resetPinInfo.getReference())});
        }
        Log.trace("TokenInfo {}", (Object)this.getP15TokenInfo());
        Log.trace("ObjectDirectory<AuthenticationObject>");
        for (i = 0; i < this.getP15AuthenticationObjectDirectory().size(); ++i) {
            obj = this.getP15AuthenticationObjectDirectory().getObject(i);
            Log.trace("{}", (Object)obj);
        }
        Log.trace("ObjectDirectory<CertificateObject>");
        for (i = 0; i < this.getP15CertificateObjectDirectory().size(); ++i) {
            obj = this.getP15CertificateObjectDirectory().getObject(i);
            Log.trace("{}", (Object)obj);
        }
        Log.trace("ObjectDirectory<PrivateKeyObject>");
        for (i = 0; i < this.getP15PrivateKeyObjectDirectory().size(); ++i) {
            obj = this.getP15PrivateKeyObjectDirectory().getObject(i);
            Log.trace("{}", (Object)obj);
        }
        Log.trace("ObjectDirectory<PublicKeyObject>");
        for (i = 0; i < this.getP15PublicKeyObjectDirectory().size(); ++i) {
            obj = this.getP15PublicKeyObjectDirectory().getObject(i);
            Log.trace("{}", (Object)obj);
        }
        Log.trace("ObjectDirectory<TrustedCertificateObject>");
        for (i = 0; i < this.getP15TrustedCertificateObjectDirectory().size(); ++i) {
            obj = this.getP15TrustedCertificateObjectDirectory().getObject(i);
            Log.trace("{}", (Object)obj);
        }
    }

    protected Collection<Pkcs15CardHolderCertificateInfo> filterCardHolderCertificateInfos(ICertificateUsageFilter filter) {
        ArrayList<Pkcs15CardHolderCertificateInfo> result = new ArrayList<Pkcs15CardHolderCertificateInfo>(3);
        for (Pkcs15CardHolderCertificateInfo info : this.getCardHolderCertificateInfos()) {
            if (!filter.accept(info.getCertificateUsage())) continue;
            result.add(info);
        }
        return result;
    }

    public CardFileSelector getApplicationAID() {
        return this.applicationAID;
    }

    public CardFileSelector getApplicationPath() {
        if (this.getApplicationAID() != null) {
            return this.getApplicationAID();
        }
        return this.getPKCS15AID();
    }

    protected Identifier getAuthId(Identifier privateKeyId) {
        PrivateKeyObject prKeyObject = this.getP15PrivateKeyObjectDirectory().getObject(privateKeyId);
        if (prKeyObject == null) {
            return null;
        }
        return prKeyObject.getAuthId();
    }

    public Collection<Pkcs15CardHolderCertificateInfo> getCardHolderCertificateInfos() {
        return this.cardHolderCertificateInfos;
    }

    public Collection<Pkcs15CardHolderCertificateInfo> getCardHolderCertificateInfosAuthentication() {
        return this.filterCardHolderCertificateInfos(new ICertificateUsageFilter(){

            public boolean accept(CertificateUsage usage) {
                return usage.isAuthentication();
            }
        });
    }

    public Collection<Pkcs15CardHolderCertificateInfo> getCardHolderCertificateInfosEncryption() {
        return this.filterCardHolderCertificateInfos(new ICertificateUsageFilter(){

            public boolean accept(CertificateUsage usage) {
                return usage.isEncryption();
            }
        });
    }

    public Collection<Pkcs15CardHolderCertificateInfo> getCardHolderCertificateInfosQes() {
        return this.filterCardHolderCertificateInfos(new ICertificateUsageFilter(){

            public boolean accept(CertificateUsage usage) {
                return usage.isSignatureWithNonRepudiation();
            }
        });
    }

    public Collection<Pkcs15CardHolderCertificateInfo> getCardHolderCertificateInfosSignature() {
        return this.filterCardHolderCertificateInfos(new ICertificateUsageFilter(){

            public boolean accept(CertificateUsage usage) {
                return usage.isSignatureWithoutNonRepudiation();
            }
        });
    }

    public List<CardFileSelector> getCertificateFiles() {
        ArrayList<CardFileSelector> result = new ArrayList<CardFileSelector>();
        for (CertificateObject o : this.getP15CertificateObjectDirectory().getObjects()) {
            result.add(o.getCardFileSelector());
        }
        return result;
    }

    public ICardCertificateInfo[] getCertificateInfosCA() {
        return this.caCertificateInfos.toArray(new CardCertificateInfo[this.caCertificateInfos.size()]);
    }

    private CertificateUsage getCertificateUsage(CertificateObject certObject) {
        KeyUsageFlags keyUsage = this.getPrivateKeyUsageFlags(certObject.getIdentifier());
        if (keyUsage != null) {
            return keyUsage.toCertificateUsage();
        }
        return CertificateUsage.UNKNOWN;
    }

    private CardFileSelector getCredentialPath(PasswordAttributes pinAttr) {
        Path path = pinAttr.getPath();
        if (path != null) {
            CardFileSelector selector = path.toCardFileSelector();
            if (selector == null) {
                return this.getApplicationPath();
            }
            return selector;
        }
        return this.getApplicationPath();
    }

    public <T extends KeyObject> List<CardFileSelector> getKeyFiles(ObjectDirectory<T> objectDirectory) {
        ArrayList<CardFileSelector> result = new ArrayList<CardFileSelector>();
        for (KeyObject o : objectDirectory.getObjects()) {
            ReferencedValue value;
            if (!o.isRSA() || (value = o.getKeyAttributes().getValue().getIndirect()) == null) continue;
            result.add(value.getPath().toCardFileSelector());
        }
        return result;
    }

    public IMessageBundle getMessageBundle() {
        if (this.messageBundle == null) {
            return Msg;
        }
        return this.messageBundle;
    }

    public ObjectDirectory<AuthenticationObject> getP15AuthenticationObjectDirectory() {
        return this.p15AuthenticationObjectDirectory;
    }

    public ObjectDirectory<CertificateObject> getP15CertificateObjectDirectory() {
        return this.p15CertificateObjectDirectory;
    }

    public ObjectDirectoryFile getP15ObjectDirectoryFile() {
        return this.p15ObjectDirectoryFile;
    }

    public ObjectDirectory<PrivateKeyObject> getP15PrivateKeyObjectDirectory() {
        return this.p15PrivateKeyObjectDirectory;
    }

    public ObjectDirectory<PublicKeyObject> getP15PublicKeyObjectDirectory() {
        return this.p15PublicKeyObjectDirectory;
    }

    public CardInfo getP15TokenInfo() {
        return this.p15TokenInfo;
    }

    public ObjectDirectory<CertificateObject> getP15TrustedCertificateObjectDirectory() {
        return this.p15TrustedCertificateObjectDirectory;
    }

    private IPinCodec getPinCodec(PasswordAttributes pinAttr) {
        CommonPinCodec pinCodec;
        int minLength = pinAttr.getMinLength();
        int storedLength = pinAttr.getStoredLength();
        int maxLength = pinAttr.getMaxLength() != null ? pinAttr.getMaxLength() : (storedLength != 0 ? storedLength : 8);
        byte[] padBytes = pinAttr.getPadBytes();
        PasswordType type = pinAttr.getPwdType();
        if (type == null) {
            pinCodec = new PinCodecAscii(0, minLength, maxLength);
        } else if (type.isAsciiNumeric() || type.isUTF8()) {
            if (padBytes == null) {
                pinCodec = new PinCodecAscii(0, minLength, maxLength);
            } else {
                pinCodec = new PinCodecAscii(padBytes[0], minLength, maxLength);
                pinCodec.setBlockSize(storedLength);
            }
        } else if (type.isISO9564p1()) {
            pinCodec = padBytes == null ? new PinCodecFormat2(-1, minLength, maxLength) : new PinCodecFormat2(padBytes[0], minLength, maxLength);
        } else if (type.isBCD()) {
            pinCodec = padBytes == null ? new PinCodecBcd(-1, minLength, maxLength) : new PinCodecBcd(padBytes[0], minLength, maxLength);
        } else {
            throw new IllegalStateException("unsupported PIN encoding type");
        }
        return pinCodec;
    }

    public Collection<PinInfo> getPinInfos() {
        return this.pinInfos.values();
    }

    public CardFileSelector getPKCS15AID() {
        return this.pkcs15AID;
    }

    protected CardFileSelector getPrivateKeyFilePath(IFileSystemApplication fileSystem, Identifier privateKeyId) {
        PrivateKeyObject prKeyObject = this.getP15PrivateKeyObjectDirectory().getObject(privateKeyId);
        Path prKeyPath = prKeyObject.getKeyAttributes().getValue().getIndirect().getPath();
        return this.sanitisePath(fileSystem, privateKeyId, prKeyPath);
    }

    public List<CardFileSelector> getPrivateKeyFiles() {
        return this.getKeyFiles(this.getP15PrivateKeyObjectDirectory());
    }

    protected int getPrivateKeySize(Identifier privateKeyId) {
        PrivateKeyObject prKeyObject = this.getP15PrivateKeyObjectDirectory().getObject(privateKeyId);
        if (prKeyObject.isRSA()) {
            AbstractKeyAttributesRSA keyAttr = ((PrivateKeyObjectRSA)prKeyObject).getPrivateRSAKeyAttributes();
            return keyAttr.getModulusLength();
        }
        if (!prKeyObject.isEC()) {
            Log.debug("Private key is not based on RSA or ECC. Id:" + privateKeyId);
        }
        return -1;
    }

    public KeyUsageFlags getPrivateKeyUsageFlags(Identifier privateKeyId) {
        PrivateKeyObject prKeyObject = this.getP15PrivateKeyObjectDirectory().getObject(privateKeyId);
        if (prKeyObject == null) {
            return null;
        }
        return prKeyObject.getUsage();
    }

    public List<CardFileSelector> getPublicKeyFiles() {
        return this.getKeyFiles(this.getP15PublicKeyObjectDirectory());
    }

    public ICardCertificateInfo[] getTrustedCertificateInfos() {
        return this.trustedCertificateInfos.toArray(new CardCertificateInfo[this.trustedCertificateInfos.size()]);
    }

    public void initialize(ICardApplicationFactory factory, ICardConnection connection) throws CardApplicationException {
        IFileSystemApplication fileSystem = factory.createCardApplication(connection, IFileSystemApplication.class);
        fileSystem.selectDf(this.getPKCS15AID(), false);
        this.loadODF(fileSystem);
        this.p15TokenInfo = PKCS15Tools.getTokenInfo(fileSystem, this.tokenInfoPath);
        if (this.getApplicationAID() == null) {
            this.deriveApplicationAID();
        }
        this.p15AuthenticationObjectDirectory = this.loadDirectoryFile(fileSystem, this.getP15ObjectDirectoryFile().getAuthenticationObjectsDirectoryPath(), AuthenticationObject.FACTORY);
        this.p15CertificateObjectDirectory = this.loadDirectoryFile(fileSystem, this.getP15ObjectDirectoryFile().getCertificateObjectsDirectoryPath(), CertificateObject.FACTORY);
        this.p15TrustedCertificateObjectDirectory = this.loadDirectoryFile(fileSystem, this.getP15ObjectDirectoryFile().getTrustedCertificateObjectsDirectoryPath(), CertificateObject.FACTORY);
        this.p15PrivateKeyObjectDirectory = this.loadDirectoryFile(fileSystem, this.getP15ObjectDirectoryFile().getPrivateKeyObjectsDirectoryPath(), PrivateKeyObject.FACTORY);
        this.p15PublicKeyObjectDirectory = this.loadDirectoryFile(fileSystem, this.getP15ObjectDirectoryFile().getPublicKeyObjectsDirectoryPath(), PublicKeyObject.FACTORY);
        for (IPkcs15StructureTransformer transformer : Transformers) {
            transformer.transform(this, factory, connection);
        }
        this.initializeAuthenticationObjects(fileSystem);
        this.initializeCertificates(fileSystem);
        this.dump();
    }

    private void initializeAuthenticationObjects(IFileSystemApplication fileSystem) {
        AuthenticationObject authObject;
        int i;
        for (i = 0; i < this.p15AuthenticationObjectDirectory.size(); ++i) {
            authObject = this.p15AuthenticationObjectDirectory.getObject(i);
            if (!authObject.isPin() || !authObject.isValid()) continue;
            PinInfo pinInfo = this.createPinInfo((AuthenticationObjectPassword)authObject);
            pinInfo.setHidden(true);
            this.pinInfos.put(pinInfo.getId(), pinInfo);
        }
        for (i = 0; i < this.p15AuthenticationObjectDirectory.size(); ++i) {
            authObject = this.p15AuthenticationObjectDirectory.getObject(i);
            if (!authObject.isPin()) continue;
            String id = Pkcs15Structure.createIdentifier(PREFIX_PIN, authObject.getIdentifier());
            String resettingId = Pkcs15Structure.createIdentifier(PREFIX_PIN, authObject.getAuthId());
            PinInfo pinInfo = this.pinInfos.get(id);
            PinInfo resettingPinInfo = this.pinInfos.get(resettingId);
            if (resettingPinInfo != null) {
                resettingPinInfo.setResetPinInfo(true);
            }
            if (pinInfo == null) continue;
            pinInfo.setResettingPinInfo(resettingPinInfo);
        }
    }

    private void initializeCertificates(IFileSystemApplication fileSystem) {
        CardFileSelector path;
        CertificateObject certObject;
        int i;
        for (i = 0; i < this.getP15TrustedCertificateObjectDirectory().size(); ++i) {
            certObject = this.getP15TrustedCertificateObjectDirectory().getObject(i);
            path = CardFileTools.resolve(this.getApplicationPath(), certObject.getCardFileSelector());
            if (CardFileTools.isEmpty(fileSystem, path)) continue;
            this.addTrustedCertificate(fileSystem, certObject);
        }
        for (i = 0; i < this.getP15CertificateObjectDirectory().size(); ++i) {
            certObject = this.getP15CertificateObjectDirectory().getObject(i);
            path = CardFileTools.resolve(this.getApplicationPath(), certObject.getCardFileSelector());
            if (CardFileTools.isEmpty(fileSystem, path)) continue;
            Identifier id = certObject.getIdentifier();
            if (this.getP15PrivateKeyObjectDirectory().contains(id)) continue;
            this.addCaCertificate(fileSystem, certObject);
        }
        ICardCertificateInfo[] caChain = new ICardCertificateInfo[this.getCertificateInfosCA().length + this.getTrustedCertificateInfos().length];
        System.arraycopy(this.getCertificateInfosCA(), 0, caChain, 0, this.getCertificateInfosCA().length);
        System.arraycopy(this.getTrustedCertificateInfos(), 0, caChain, this.getCertificateInfosCA().length, this.getTrustedCertificateInfos().length);
        for (int i2 = 0; i2 < this.getP15CertificateObjectDirectory().size(); ++i2) {
            CertificateObject certObject2 = this.getP15CertificateObjectDirectory().getObject(i2);
            CardFileSelector path2 = CardFileTools.resolve(this.getApplicationPath(), certObject2.getCardFileSelector());
            if (CardFileTools.isEmpty(fileSystem, path2)) continue;
            Identifier id = certObject2.getIdentifier();
            if (!this.getP15PrivateKeyObjectDirectory().contains(id)) continue;
            this.addCardHolderCertificateInfo(fileSystem, certObject2, caChain);
        }
    }

    private <T extends Pkcs15Object> ObjectDirectory<T> loadDirectoryFile(IFileSystemApplication fileSystem, CardFileSelector path, Pkcs15Object.Factory<T> factory) throws CardApplicationException {
        if (path == null) {
            return new ObjectDirectory();
        }
        path = this.getPKCS15AID().resolve(path);
        CardFileInfo fileInfo = fileSystem.selectEf(path, true);
        try {
            List elements;
            if (fileInfo == null || fileInfo.isTransparent()) {
                byte[] data = fileSystem.readBinaryCached(path);
                elements = ASN1Tools.createAll((byte[])data);
            } else {
                byte[][] data = fileSystem.readRecordsCached(path, Integer.MAX_VALUE);
                elements = ASN1Tools.createAll((byte[][])data);
            }
            return this.createObjectDirectory(path, factory, elements);
        }
        catch (Exception e) {
            if (Log.isEnabledForLevel(Level.DEBUG)) {
                Log.debug(e.getLocalizedMessage(), (Throwable)e);
            }
            return new ObjectDirectory(path);
        }
    }

    private void loadODF(IFileSystemApplication fileSystem) throws CardApplicationException {
        byte[] odfData = fileSystem.readBinaryCached(this.odfFilePath);
        try {
            List directoryObjects = ASN1Tools.createAll((byte[])odfData);
            this.p15ObjectDirectoryFile = new ObjectDirectoryFile(directoryObjects);
        }
        catch (Exception e) {
            throw CardApplicationException.create(e);
        }
    }

    public PinInfo lookupPinInfo(String id) {
        return this.pinInfos.get(id);
    }

    private CardFileSelector sanitisePath(IFileSystemApplication fileSystem, Identifier privateKeyId, Path prKeyPath) {
        if (prKeyPath == null) {
            return null;
        }
        CardFileSelector selector = prKeyPath.toCardFileSelector();
        if (selector == null) {
            return this.getApplicationPath().resolve(this.createSymbolicFile(privateKeyId.getByteValue()));
        }
        CardFileSelector path = CardFileTools.resolve(this.getApplicationPath(), selector);
        try {
            fileSystem.selectEf(path, false);
        }
        catch (Exception e) {
            path = path.resolve(this.createSymbolicFile(privateKeyId.getByteValue()));
        }
        return path;
    }

    public void setApplicationAID(CardFileSelector applicationAID) {
        this.applicationAID = applicationAID;
    }

    public void setMessageBundle(IMessageBundle messageBundle) {
        this.messageBundle = messageBundle;
    }

    protected void setP15AuthenticationObjectDirectory(ObjectDirectory<AuthenticationObject> p15AuthenticationObjectDirectory) {
        this.p15AuthenticationObjectDirectory = p15AuthenticationObjectDirectory;
    }

    protected void setP15CertificateObjectDirectory(ObjectDirectory<CertificateObject> p15CertificateObjectDirectory) {
        this.p15CertificateObjectDirectory = p15CertificateObjectDirectory;
    }

    protected void setP15ObjectDirectoryFile(ObjectDirectoryFile p15ObjectDirectoryFile) {
        this.p15ObjectDirectoryFile = p15ObjectDirectoryFile;
    }

    protected void setP15PrivateKeyObjectDirectory(ObjectDirectory<PrivateKeyObject> p15PrivateKeyObjectDirectory) {
        this.p15PrivateKeyObjectDirectory = p15PrivateKeyObjectDirectory;
    }

    protected void setP15PublicKeyObjectDirectory(ObjectDirectory<PublicKeyObject> p15PublicKeyObjectDirectory) {
        this.p15PublicKeyObjectDirectory = p15PublicKeyObjectDirectory;
    }

    protected void setP15TrustedCertificateObjectDirectory(ObjectDirectory<CertificateObject> p15TrustedCertificateObjectDirectory) {
        this.p15TrustedCertificateObjectDirectory = p15TrustedCertificateObjectDirectory;
    }

    public void setPKCS15AID(CardFileSelector pPkcs15aid) {
        this.pkcs15AID = pPkcs15aid;
    }

    private <T extends Pkcs15Object> List<T> subtypeElements(List<ASN1Primitive> elements, Pkcs15Object.Factory<T> factory) {
        ArrayList<Pkcs15Object> result = new ArrayList<Pkcs15Object>();
        for (ASN1Encodable aSN1Encodable : elements) {
            try {
                Pkcs15Object subtype = (Pkcs15Object)factory.create(aSN1Encodable);
                if (subtype == null) continue;
                result.add(subtype);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    static {
        Transformers.add(new DTrustV4Transformer());
        Msg = PACKAGE.Messages;
        Log = LoggerFactory.getLogger(Pkcs15Structure.class);
        PKCS15_AID = new CardFileName("\u00a0\u0000\u0000\u0000cPKCS-15");
        PKCS15_STRING = new byte[]{80, 75, 67, 83, 45, 49, 53};
        RID = new byte[]{-96, 0, 0, 0, 99};
        ISO_AID_PREFIX = HexTools.hexStringToBytes((String)"E828BD080F");
    }
}

