/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.smartcard.pkcs15.CommonPrivateKeyAttributes;
import de.intarsys.security.smartcard.pkcs15.KeyObject;
import de.intarsys.security.smartcard.pkcs15.PrivateKeyObjectAny;
import de.intarsys.security.smartcard.pkcs15.PrivateKeyObjectEC;
import de.intarsys.security.smartcard.pkcs15.PrivateKeyObjectRSA;
import de.intarsys.tools.reflect.ObjectCreationException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1TaggedObject;

public abstract class PrivateKeyObject
extends KeyObject {
    public static final Factory<PrivateKeyObject> FACTORY = new Factory();
    private CommonPrivateKeyAttributes commonPrivateKeyAttributes;

    protected PrivateKeyObject() {
    }

    public CommonPrivateKeyAttributes getCommonPrivateKeyAttributes() {
        return this.commonPrivateKeyAttributes;
    }

    @Override
    public ASN1Based getSubClassAttributes() {
        return this.getCommonPrivateKeyAttributes();
    }

    @Override
    protected void initializeAfterCreate() {
        super.initializeAfterCreate();
        this.commonPrivateKeyAttributes = (CommonPrivateKeyAttributes)CommonPrivateKeyAttributes.FACTORY.create((ASN1Encodable)this.baseGetSubClassAttributes());
    }

    static class Factory<T extends PrivateKeyObject>
    extends KeyObject.Factory<T> {
        Factory() {
        }

        protected T basicCreate(ASN1Encodable asn1) throws ObjectCreationException {
            if (asn1 instanceof ASN1TaggedObject) {
                ASN1TaggedObject taggedObject = (ASN1TaggedObject)asn1;
                asn1 = taggedObject.getBaseObject();
            }
            return (T)((Object)((PrivateKeyObject)super.basicCreate(asn1)));
        }

        protected ASN1Based.Factory selectSubtypeFactory(ASN1Encodable o) throws ObjectCreationException {
            if (o == null) {
                return null;
            }
            if (ASN1Tools.isASN1Sequence((ASN1Encodable)o)) {
                return PrivateKeyObjectRSA.FACTORY;
            }
            if (ASN1Tools.isASN1Tagged((ASN1Encodable)o)) {
                ASN1TaggedObject tagged = (ASN1TaggedObject)o.toASN1Primitive();
                switch (tagged.getTagNo()) {
                    case 0: {
                        return PrivateKeyObjectEC.FACTORY;
                    }
                }
                return PrivateKeyObjectAny.FACTORY;
            }
            throw new ObjectCreationException("PrivateKeyObject based on " + o + " not supported");
        }
    }
}

