/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.smartcard.pkcs15.CommonPublicKeyAttributes;
import de.intarsys.security.smartcard.pkcs15.KeyObject;
import de.intarsys.security.smartcard.pkcs15.PublicKeyObjectAny;
import de.intarsys.security.smartcard.pkcs15.PublicKeyObjectRSA;
import de.intarsys.tools.reflect.ObjectCreationException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1TaggedObject;

public abstract class PublicKeyObject
extends KeyObject {
    public static final Factory<PublicKeyObject> FACTORY = new Factory();
    private CommonPublicKeyAttributes commonPublicKeyAttributes;

    protected PublicKeyObject() {
    }

    public CommonPublicKeyAttributes getCommonPublicKeyAttributes() {
        return this.commonPublicKeyAttributes;
    }

    @Override
    public ASN1Based getSubClassAttributes() {
        return this.getCommonPublicKeyAttributes();
    }

    @Override
    protected void initializeAfterCreate() {
        super.initializeAfterCreate();
        this.commonPublicKeyAttributes = (CommonPublicKeyAttributes)CommonPublicKeyAttributes.FACTORY.create((ASN1Encodable)this.baseGetSubClassAttributes());
    }

    public void setCommonPublicKeyAttributes(CommonPublicKeyAttributes commonPublicKeyAttributes) {
        this.commonPublicKeyAttributes = commonPublicKeyAttributes;
    }

    static class Factory<T extends PublicKeyObject>
    extends KeyObject.Factory<T> {
        Factory() {
        }

        protected T basicCreate(ASN1Encodable asn1) throws ObjectCreationException {
            if (asn1 instanceof ASN1TaggedObject) {
                ASN1TaggedObject taggedObject = (ASN1TaggedObject)asn1;
                asn1 = taggedObject.getBaseObject();
            }
            return (T)((Object)((PublicKeyObject)super.basicCreate(asn1)));
        }

        protected ASN1Based.Factory selectSubtypeFactory(ASN1Encodable o) throws ObjectCreationException {
            if (o == null) {
                return null;
            }
            if (ASN1Tools.isASN1Sequence((ASN1Encodable)o)) {
                return PublicKeyObjectRSA.FACTORY;
            }
            if (ASN1Tools.isASN1Tagged((ASN1Encodable)o)) {
                return PublicKeyObjectAny.FACTORY;
            }
            throw new ObjectCreationException("PublicKeyObject based on " + o + " not supported");
        }
    }
}

