/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.smartcard.pkcs15.KeyObject;
import de.intarsys.security.smartcard.pkcs15.SecretKeyObjectAny;
import de.intarsys.tools.reflect.ObjectCreationException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1TaggedObject;

public abstract class SecretKeyObject
extends KeyObject {
    public static final Factory<SecretKeyObject> FACTORY = new Factory();

    protected SecretKeyObject() {
    }

    static class Factory<T extends SecretKeyObject>
    extends KeyObject.Factory<T> {
        Factory() {
        }

        protected T basicCreate(ASN1Encodable asn1) throws ObjectCreationException {
            if (asn1 instanceof ASN1TaggedObject) {
                ASN1TaggedObject taggedObject = (ASN1TaggedObject)asn1;
                asn1 = taggedObject.getBaseObject();
            }
            return (T)((Object)((SecretKeyObject)super.basicCreate(asn1)));
        }

        protected ASN1Based.Factory selectSubtypeFactory(ASN1Encodable o) throws ObjectCreationException {
            if (o == null) {
                return null;
            }
            if (ASN1Tools.isASN1Sequence((ASN1Encodable)o)) {
                return SecretKeyObjectAny.FACTORY;
            }
            if (ASN1Tools.isASN1Tagged((ASN1Encodable)o)) {
                return SecretKeyObjectAny.FACTORY;
            }
            throw new ObjectCreationException("SecretKeyObject based on " + o + " not supported");
        }
    }
}

