/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pkcs15;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.string.PrettyPrinter;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;

public class SecurityEnvironmentInfo
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public byte[] getAid() {
        ASN1ValueHolder o = this.getValueHolder().getNextTyped(1, ASN1OctetString.class);
        if (o != null) {
            return o.toDEROctetString().getOctets();
        }
        return null;
    }

    public String getOwner() {
        ASN1ValueHolder o = this.getValueHolder().getNextTyped(1, ASN1ObjectIdentifier.class);
        if (o != null) {
            return o.toDERObjectIdentifier().getId();
        }
        return null;
    }

    public int getSecurityEnvironment() {
        return this.getValueHolder().getChild(0).toDERInteger().getPositiveValue().intValue();
    }

    public void toString(PrettyPrinter printer) {
        printer.appendMember("se", (Object)this.getSecurityEnvironment(), null);
        printer.appendMember("owner", (Object)this.getOwner(), null);
        printer.appendMember("aid", (Object)this.getAid(), null);
    }

    static class Factory
    extends ASN1Based.Factory<SecurityEnvironmentInfo> {
        Factory() {
        }
    }
}

