/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.asn1;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.exception.UnreachableCodeError;
import de.intarsys.tools.string.PrettyPrinter;
import de.intarsys.tr3110.asn1.Asn1Tools;
import de.intarsys.tr3110.asn1.CertificateExtensions;
import de.intarsys.tr3110.asn1.CertificateHolderAuthorizationTemplate;
import de.intarsys.tr3110.asn1.CertificateReference;
import de.intarsys.tr3110.asn1.PublicKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;

public class CertificateBody
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public byte[] getCertificateEffective() {
        return this.getSequenceHolder().getChild(5).getChild().toBytes();
    }

    public Calendar getCertificateEffectiveDate() {
        return Asn1Tools.parseDate(this.getCertificateEffective());
    }

    public byte[] getCertificateExpiration() {
        return this.getSequenceHolder().getChild(6).getChild().toBytes();
    }

    public Calendar getCertificateExpirationDate() {
        return Asn1Tools.parseDate(this.getCertificateExpiration());
    }

    public CertificateExtensions getCertificateExtensions() {
        if (this.getSequenceHolder().size() <= 7) {
            return null;
        }
        return (CertificateExtensions)CertificateExtensions.FACTORY.create((ASN1Encodable)this.getSequenceHolder().getChild(7));
    }

    public byte[] getCertificateExtensionsBytes() {
        byte[] byArray;
        if (this.getSequenceHolder().size() <= 7) {
            return null;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            Iterator iterator = this.getSequenceHolder().getChild(7).getChild().iterator();
            while (iterator.hasNext()) {
                ((ASN1ValueHolder)iterator.next()).getValue().encodeTo((OutputStream)stream);
            }
            byArray = stream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new UnreachableCodeError();
            }
        }
        stream.close();
        return byArray;
    }

    public CertificateReference getCertificateHolderReference() {
        return new CertificateReference(this.getSequenceHolder().getChild(3).getChild().toBytes());
    }

    public CertificateReference getCertificationAuthorityReference() {
        return new CertificateReference(this.getSequenceHolder().getChild(1).getChild().toBytes());
    }

    public CertificateHolderAuthorizationTemplate getChat() {
        return (CertificateHolderAuthorizationTemplate)CertificateHolderAuthorizationTemplate.FACTORY.create((ASN1Encodable)this.getSequenceHolder().getChild(4));
    }

    public byte[] getProfileIdentifier() {
        return this.getSequenceHolder().getChild(0).getChild().toBytes();
    }

    public PublicKey getPublicKey() {
        return (PublicKey)PublicKey.FACTORY.create((ASN1Encodable)this.getSequenceHolder().getChild(2));
    }

    protected ASN1ValueHolder getSequenceHolder() {
        return this.getValueHolder().getChild();
    }

    public void toString(PrettyPrinter printer) {
        printer.appendMember("CertificateProfileIdentifier", (Object)this.getProfileIdentifier(), null);
        printer.appendMember("CertificationAuthorityReference", (Object)this.getCertificationAuthorityReference(), null);
        printer.appendMember("PublicKey", (Object)this.getPublicKey(), null);
        printer.appendMember("certificatHolderReference", (Object)this.getCertificateHolderReference(), null);
        printer.appendMember("certificateHolderAuthorization", (Object)this.getChat(), null);
        printer.appendMember("CertificateEffectiveDate", (Object)this.getCertificateEffective(), null);
        printer.appendMember("certificateExpirationDate", (Object)this.getCertificateExpiration(), null);
        printer.appendMember("certificateExtensions", (Object)this.getCertificateExtensions(), null);
    }

    public static class Factory
    extends ASN1Based.Factory<CertificateBody> {
        public boolean isExplicit() {
            return false;
        }
    }
}

