/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.asn1;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.string.PrettyPrinter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1String;

public class CertificateDescription
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public List<byte[]> getCommCertificates() {
        ASN1ValueHolder temp = this.getValueHolder().getNextTaggedGetChild(0, 7, true);
        if (temp == null) {
            return Collections.emptyList();
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (int i = 0; i < temp.size(); ++i) {
            ASN1ValueHolder child = temp.getChild(i);
            result.add(child.toDEROctetString().getOctets());
        }
        return result;
    }

    public String getDescriptionType() {
        return this.getValueHolder().getChild(0).toDERObjectIdentifier().getId();
    }

    public String getIssuerName() {
        ASN1ValueHolder temp = this.getValueHolder().getNextTaggedGetChild(0, 1, true);
        if (temp == null) {
            return null;
        }
        return ((ASN1String)temp.toASN1Primitive()).getString();
    }

    public String getIssuerURL() {
        ASN1ValueHolder temp = this.getValueHolder().getNextTaggedGetChild(0, 2, true);
        if (temp == null) {
            return null;
        }
        return ((ASN1String)temp.toASN1Primitive()).getString();
    }

    public String getRedirectURL() {
        ASN1ValueHolder temp = this.getValueHolder().getNextTaggedGetChild(0, 6, true);
        if (temp == null) {
            return null;
        }
        return ((ASN1String)temp.toASN1Primitive()).getString();
    }

    public String getSubjectName() {
        ASN1ValueHolder temp = this.getValueHolder().getNextTaggedGetChild(0, 3, true);
        if (temp == null) {
            return null;
        }
        return ((ASN1String)temp.toASN1Primitive()).getString();
    }

    public String getSubjectURL() {
        ASN1ValueHolder temp = this.getValueHolder().getNextTaggedGetChild(0, 4, true);
        if (temp == null) {
            return null;
        }
        return ((ASN1String)temp.toASN1Primitive()).getString();
    }

    public Object getTermsOfUsage() {
        ASN1ValueHolder temp = this.getValueHolder().getNextTaggedGetChild(0, 5, true);
        if (temp == null) {
            return null;
        }
        if ("0.4.0.127.0.7.3.1.3.1.1".equals(this.getDescriptionType())) {
            return ((ASN1String)temp.toASN1Primitive()).getString();
        }
        if ("0.4.0.127.0.7.3.1.3.1.2".equals(this.getDescriptionType())) {
            return ((ASN1String)temp.toASN1Primitive()).getString();
        }
        if ("0.4.0.127.0.7.3.1.3.1.3".equals(this.getDescriptionType())) {
            return temp.toDEROctetString().getOctets();
        }
        return null;
    }

    public void toString(PrettyPrinter printer) {
        printer.appendMember("descriptionType", (Object)this.getDescriptionType(), null);
        printer.appendMember("issuerName", (Object)this.getIssuerName(), null);
        printer.appendMember("issuerURL", (Object)this.getIssuerURL(), null);
        printer.appendMember("subjectName", (Object)this.getSubjectName(), null);
        printer.appendMember("subjectURL", (Object)this.getSubjectURL(), null);
        printer.appendMember("termsOfUsage", this.getTermsOfUsage(), null);
        printer.appendMember("redirectURL", (Object)this.getRedirectURL(), null);
        printer.appendMember("commCertificates", this.getCommCertificates(), null);
    }

    public static class Factory
    extends ASN1Based.Factory<CertificateDescription> {
    }
}

