/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.asn1;

import de.intarsys.asn1.model.ASN1ApplicationSpecificHolder;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.string.PrettyPrinter;
import de.intarsys.tr3110.asn1.Constants;
import de.intarsys.tr3110.asn1.DiscretionaryData;
import de.intarsys.tr3110.common.CommonTools;
import de.intarsys.tr3110.common.TerminalRole;
import de.intarsys.tr3110.common.TerminalRoleRole;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;

public class CertificateHolderAuthorizationTemplate
extends ASN1Based {
    protected static final Permission[] Permissions_AT = new Permission[]{new Permission("SF_AGE_VERIFICATION", "execute", 0), new Permission("SF_COMMUNITY_ID", "execute", 1), new Permission("SF_RESTRICTED_IDENTIFICATION", "execute", 2), new Permission("SF_PRIVILEGED_TERMINAL", "execute", 3), new Permission("SF_CAN_ALLOWED", "execute", 4), new Permission("SF_PIN_MANAGEMENT", "execute", 5), new Permission("SF_INSTALL_C", "execute", 6), new Permission("SF_INSTALL_QC", "execute", 7), new Permission("DG01", "read", 8), new Permission("DG02", "read", 9), new Permission("DG03", "read", 10), new Permission("DG04", "read", 11), new Permission("DG05", "read", 12), new Permission("DG06", "read", 13), new Permission("DG07", "read", 14), new Permission("DG08", "read", 15), new Permission("DG09", "read", 16), new Permission("DG10", "read", 17), new Permission("DG11", "read", 18), new Permission("DG12", "read", 19), new Permission("DG13", "read", 20), new Permission("DG14", "read", 21), new Permission("DG15", "read", 22), new Permission("DG16", "read", 23), new Permission("DG17", "read", 24), new Permission("DG18", "read", 25), new Permission("DG19", "read", 26), new Permission("DG20", "read", 27), new Permission("DG21", "read", 28), new Permission("DG21", "write", 33), new Permission("DG20", "write", 34), new Permission("DG19", "write", 35), new Permission("DG18", "write", 36), new Permission("DG17", "write", 37)};
    protected static final Permission[] Permissions_IS = new Permission[]{new Permission("DG03", "read", 0), new Permission("DG04", "read", 1)};
    protected static final Permission[] Permissions_ST = new Permission[]{new Permission("SF_GENERATE_ES", "execute", 0), new Permission("SF_GENERATE_QES", "execute", 1)};
    public static final Factory FACTORY = new Factory();
    public static final int TAG = 76;
    private final Map<Permission, Boolean> permissions = new HashMap<Permission, Boolean>();
    private TerminalRoleRole terminalRoleRole;
    private TerminalRole terminalRole;

    public static CertificateHolderAuthorizationTemplate create(String id, byte[] discretionaryData) throws IOException {
        if (id == null) {
            return null;
        }
        if (discretionaryData == null) {
            discretionaryData = new byte[]{};
        }
        DiscretionaryData dd = DiscretionaryData.create(discretionaryData);
        CertificateHolderAuthorizationTemplate asnCHAT = (CertificateHolderAuthorizationTemplate)FACTORY.createNew();
        asnCHAT.setIdentifier(id);
        asnCHAT.setDiscretionaryData(dd);
        return asnCHAT;
    }

    public static String getLabel(String code) {
        for (int i = 0; i < Constants.DataGroupsDesc.length; ++i) {
            if (!Constants.DataGroupsDesc[i][0].equals(code)) continue;
            return Constants.DataGroupsDesc[i][1];
        }
        return code;
    }

    public static Permission getPermissionAT(String resource, String action) {
        for (int i = 0; i < Permissions_AT.length; ++i) {
            if (!CertificateHolderAuthorizationTemplate.Permissions_AT[i].resource.equals(resource) || !CertificateHolderAuthorizationTemplate.Permissions_AT[i].action.equals(action)) continue;
            return Permissions_AT[i];
        }
        return null;
    }

    public static Permission getPermissionIS(String resource, String action) {
        for (int i = 0; i < Permissions_IS.length; ++i) {
            if (!CertificateHolderAuthorizationTemplate.Permissions_IS[i].resource.equals(resource) || !CertificateHolderAuthorizationTemplate.Permissions_IS[i].action.equals(action)) continue;
            return Permissions_IS[i];
        }
        return null;
    }

    public static Permission getPermissionST(String resource, String action) {
        for (int i = 0; i < Permissions_ST.length; ++i) {
            if (!CertificateHolderAuthorizationTemplate.Permissions_ST[i].resource.equals(resource) || !CertificateHolderAuthorizationTemplate.Permissions_ST[i].action.equals(action)) continue;
            return Permissions_ST[i];
        }
        return null;
    }

    public void allow(CertificateHolderAuthorizationTemplate other) {
        for (Map.Entry<Permission, Boolean> entry : this.permissions.entrySet()) {
            if (!other.isAllowed(entry.getKey())) continue;
            entry.setValue(true);
        }
        this.serializePermissions();
    }

    protected boolean basicIsAllowed(Permission permission) {
        return this.permissions.get(permission) == null ? false : this.permissions.get(permission);
    }

    protected void basicSetAllowed(Permission permission, boolean value) {
        this.permissions.put(permission, value);
    }

    public CertificateHolderAuthorizationTemplate copy() {
        try {
            return (CertificateHolderAuthorizationTemplate)ASN1BasedTools.create((ASN1Based.Factory)FACTORY, (byte[])this.getDEREncoded());
        }
        catch (IOException e) {
            return null;
        }
    }

    public void disallow(CertificateHolderAuthorizationTemplate other) {
        for (Map.Entry<Permission, Boolean> entry : this.permissions.entrySet()) {
            if (other.isAllowed(entry.getKey())) continue;
            entry.setValue(false);
        }
        this.serializePermissions();
    }

    public DiscretionaryData getDiscretionaryData() {
        return (DiscretionaryData)DiscretionaryData.FACTORY.create((ASN1Encodable)this.getValueHolder().getChild().getChild(1));
    }

    public String getDiscretionaryDataLabel() {
        StringBuilder sb;
        block4: {
            String id;
            block5: {
                block3: {
                    sb = new StringBuilder();
                    id = this.getIdentifier();
                    if (!"0.4.0.127.0.7.3.1.2.2".equals(id)) break block3;
                    for (int i = 0; i < Permissions_AT.length; ++i) {
                        if (!this.isAllowed(Permissions_AT[i])) continue;
                        sb.append(CertificateHolderAuthorizationTemplate.Permissions_AT[i].action);
                        sb.append(" ");
                        sb.append(CertificateHolderAuthorizationTemplate.getLabel(CertificateHolderAuthorizationTemplate.Permissions_AT[i].resource));
                        sb.append(", ");
                    }
                    break block4;
                }
                if (!"0.4.0.127.0.7.3.1.2.1".equals(id)) break block5;
                for (int i = 0; i < Permissions_IS.length; ++i) {
                    if (!this.isAllowed(Permissions_IS[i])) continue;
                    sb.append(CertificateHolderAuthorizationTemplate.Permissions_IS[i].action);
                    sb.append(" ");
                    sb.append(CertificateHolderAuthorizationTemplate.getLabel(CertificateHolderAuthorizationTemplate.Permissions_IS[i].resource));
                    sb.append(", ");
                }
                break block4;
            }
            if (!"0.4.0.127.0.7.3.1.2.3".equals(id)) break block4;
            for (int i = 0; i < Permissions_ST.length; ++i) {
                if (!this.isAllowed(Permissions_ST[i])) continue;
                sb.append(CertificateHolderAuthorizationTemplate.Permissions_ST[i].action);
                sb.append(" ");
                sb.append(CertificateHolderAuthorizationTemplate.getLabel(CertificateHolderAuthorizationTemplate.Permissions_ST[i].resource));
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    protected boolean getFlag(byte[] ddData, int i) {
        int byteIndex = ddData.length - 1 - i / 8;
        int bitMask = 1 << i % 8;
        return (ddData[byteIndex] & bitMask) != 0;
    }

    public String getIdentifier() {
        return this.getValueHolder().getChild().getChild(0).toDERObjectIdentifier().getId();
    }

    public TerminalRole getTerminalRole() {
        return this.terminalRole;
    }

    public TerminalRoleRole getTerminalRoleRole() {
        return this.terminalRoleRole;
    }

    protected void initializeAfterCreate() {
        super.initializeAfterCreate();
        this.parseRoleRole();
        this.parseRole();
        this.parsePermissions();
    }

    public boolean isAllowed(Permission permission) {
        return this.basicIsAllowed(permission);
    }

    public boolean isAllowed(String resource, String action) {
        Permission p = null;
        if (this.getTerminalRole() == TerminalRole.AUTHENTICATION_TERMINAL) {
            p = CertificateHolderAuthorizationTemplate.getPermissionAT(resource, action);
        } else if (this.getTerminalRole() == TerminalRole.INSPECTION_SYSTEM) {
            p = CertificateHolderAuthorizationTemplate.getPermissionIS(resource, action);
        } else if (this.getTerminalRole() == TerminalRole.SIGNATURE_TERMINAL) {
            p = CertificateHolderAuthorizationTemplate.getPermissionST(resource, action);
        }
        if (p == null) {
            throw new IllegalArgumentException("unsupported permission");
        }
        return this.isAllowed(p);
    }

    public boolean isAllowedExecute(String resource) {
        return this.isAllowed(resource, "execute");
    }

    public boolean isAllowedRead(String resource) {
        return this.isAllowed(resource, "read");
    }

    public boolean isAllowedWrite(String resource) {
        return this.isAllowed(resource, "write");
    }

    protected void parsePermissions() {
        block4: {
            String id;
            byte[] ddData;
            block5: {
                block3: {
                    DiscretionaryData dd = this.getDiscretionaryData();
                    ddData = dd.getData();
                    id = this.getIdentifier();
                    if (!"0.4.0.127.0.7.3.1.2.2".equals(id)) break block3;
                    for (int i = 0; i < Permissions_AT.length; ++i) {
                        this.basicSetAllowed(Permissions_AT[i], this.getFlag(ddData, CertificateHolderAuthorizationTemplate.Permissions_AT[i].bit));
                    }
                    break block4;
                }
                if (!"0.4.0.127.0.7.3.1.2.1".equals(id)) break block5;
                for (int i = 0; i < Permissions_IS.length; ++i) {
                    this.basicSetAllowed(Permissions_IS[i], this.getFlag(ddData, CertificateHolderAuthorizationTemplate.Permissions_IS[i].bit));
                }
                break block4;
            }
            if (!"0.4.0.127.0.7.3.1.2.3".equals(id)) break block4;
            for (int i = 0; i < Permissions_ST.length; ++i) {
                this.basicSetAllowed(Permissions_ST[i], this.getFlag(ddData, CertificateHolderAuthorizationTemplate.Permissions_ST[i].bit));
            }
        }
    }

    protected void parseRole() {
        String id = this.getIdentifier();
        this.terminalRole = "0.4.0.127.0.7.3.1.2.2".equals(id) ? TerminalRole.AUTHENTICATION_TERMINAL : ("0.4.0.127.0.7.3.1.2.1".equals(id) ? TerminalRole.INSPECTION_SYSTEM : ("0.4.0.127.0.7.3.1.2.3".equals(id) ? TerminalRole.SIGNATURE_TERMINAL : TerminalRole.UNKNOWN));
    }

    protected void parseRoleRole() {
        DiscretionaryData dd = this.getDiscretionaryData();
        byte[] ddData = dd.getData();
        int role = ddData[0] & 0xC0;
        this.terminalRoleRole = role == 192 ? TerminalRoleRole.CVCA : (role == 128 ? TerminalRoleRole.DV_DOMESTIC : (role == 64 ? TerminalRoleRole.DV_FOREIGN : TerminalRoleRole.BASIC));
    }

    protected void serializePermissions() {
        DiscretionaryData dd = this.getDiscretionaryData();
        byte[] ddData = dd.getData();
        String id = this.getIdentifier();
        if ("0.4.0.127.0.7.3.1.2.2".equals(id)) {
            for (int i = 0; i < Permissions_AT.length; ++i) {
                this.setFlag(ddData, CertificateHolderAuthorizationTemplate.Permissions_AT[i].bit, this.isAllowed(Permissions_AT[i]));
            }
            this.getDiscretionaryData().setData(ddData);
        } else if ("0.4.0.127.0.7.3.1.2.1".equals(id)) {
            for (int i = 0; i < Permissions_IS.length; ++i) {
                this.setFlag(ddData, CertificateHolderAuthorizationTemplate.Permissions_IS[i].bit, this.isAllowed(Permissions_IS[i]));
            }
            this.getDiscretionaryData().setData(ddData);
        } else if ("0.4.0.127.0.7.3.1.2.3".equals(id)) {
            for (int i = 0; i < Permissions_ST.length; ++i) {
                this.setFlag(ddData, CertificateHolderAuthorizationTemplate.Permissions_ST[i].bit, this.isAllowed(Permissions_ST[i]));
            }
            this.getDiscretionaryData().setData(ddData);
        }
    }

    public void setAllowed(Permission permission, boolean value) {
        this.basicSetAllowed(permission, value);
        this.serializePermissions();
    }

    public void setAllowed(String resource, String action, boolean value) {
        Permission p = null;
        if (this.getTerminalRole() == TerminalRole.AUTHENTICATION_TERMINAL) {
            p = CertificateHolderAuthorizationTemplate.getPermissionAT(resource, action);
        } else if (this.getTerminalRole() == TerminalRole.INSPECTION_SYSTEM) {
            p = CertificateHolderAuthorizationTemplate.getPermissionIS(resource, action);
        } else if (this.getTerminalRole() == TerminalRole.SIGNATURE_TERMINAL) {
            p = CertificateHolderAuthorizationTemplate.getPermissionST(resource, action);
        }
        if (p == null) {
            throw new IllegalArgumentException("unsupported permission");
        }
        this.setAllowed(p, value);
    }

    public void setAllowedExecute(String resource, boolean value) {
        this.setAllowed(resource, "execute", value);
    }

    public void setAllowedRead(String resource, boolean value) {
        this.setAllowed(resource, "read", value);
    }

    public void setAllowedWrite(String resource, boolean value) {
        this.setAllowed(resource, "write", value);
    }

    public void setDiscretionaryData(DiscretionaryData data) {
        this.getValueHolder().getChild().setChild(1, (ASN1Encodable)data);
    }

    protected void setFlag(byte[] ddData, int i, boolean value) {
        int byteIndex = ddData.length - 1 - i / 8;
        int bitMask = 1 << i % 8;
        ddData[byteIndex] = value ? (byte)(ddData[byteIndex] | bitMask) : (byte)(ddData[byteIndex] & ~bitMask);
    }

    public void setIdentifier(String id) {
        this.getValueHolder().getChild().setChild(0, (ASN1Encodable)new ASN1ObjectIdentifier(id));
    }

    public void toString(PrettyPrinter printer) {
        printer.appendMember("identifier", (Object)this.getIdentifier(), CommonTools.resolveOid(this.getIdentifier()));
        printer.appendMember("discretionaryData", (Object)this.getDiscretionaryData(), this.getDiscretionaryDataLabel());
    }

    public static class Factory
    extends ASN1Based.Factory<CertificateHolderAuthorizationTemplate> {
        protected ASN1ValueHolder basicCreateValueHolder() {
            return new ASN1ApplicationSpecificHolder(this.isExplicit(), 76, (ASN1Encodable)new DERSequence());
        }

        public boolean isExplicit() {
            return false;
        }
    }

    public static class Permission {
        final String code;
        final String resource;
        final String action;
        final int bit;

        public Permission(String resource, String action, int bit) {
            this.resource = resource;
            this.action = action;
            this.code = resource + "-" + action;
            this.bit = bit;
        }
    }
}

