/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.asn1;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class CertificateReference {
    private String countryCode = "";
    private String holderMnemonic = "";
    private String sequenceNumber = "";
    private int hash;

    public CertificateReference(byte[] contents) {
        String temp = new String(contents, StandardCharsets.ISO_8859_1);
        if (temp.length() >= 2) {
            this.countryCode = temp.substring(0, 2);
        }
        if (temp.length() >= 7) {
            this.holderMnemonic = temp.substring(2, temp.length() - 5);
            this.sequenceNumber = temp.substring(temp.length() - 5);
        }
    }

    public CertificateReference(String countryCode, String holderMnemonic, String sequenceNumber) throws IOException {
        this.countryCode = countryCode;
        this.holderMnemonic = holderMnemonic;
        this.sequenceNumber = sequenceNumber;
    }

    public boolean equals(Object other) {
        if (!(other instanceof CertificateReference)) {
            return false;
        }
        return Arrays.equals(this.getEncoded(), ((CertificateReference)other).getEncoded());
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public byte[] getEncoded() {
        String temp = this.countryCode + this.holderMnemonic + this.sequenceNumber;
        return temp.getBytes(StandardCharsets.ISO_8859_1);
    }

    public String getHolderMnemonic() {
        return this.holderMnemonic;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            byte[] value = this.getEncoded();
            for (int i = 0; i < value.length; ++i) {
                h = 31 * h + value[i];
            }
            this.hash = h;
        }
        return h;
    }

    public String toString() {
        return this.countryCode + "-" + this.holderMnemonic + "-" + this.sequenceNumber;
    }
}

