/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.asn1;

import de.intarsys.asn1.model.ASN1ApplicationSpecificHolder;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.string.PrettyPrinter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;

public class DiscretionaryData
extends ASN1Based {
    public static final Factory FACTORY = new Factory();
    public static final int TAG = 19;

    public static DiscretionaryData create(byte[] data) {
        DiscretionaryData result = (DiscretionaryData)FACTORY.createNew();
        result.setData(data);
        return result;
    }

    public byte[] getData() {
        return this.getValueHolder().getChild().toBytes();
    }

    public void setData(byte[] data) {
        this.getValueHolder().setChild((ASN1Encodable)new DEROctetString(data));
    }

    public void toString(PrettyPrinter printer) {
        printer.appendValue((Object)this.getData());
    }

    public static class Factory
    extends ASN1Based.Factory<DiscretionaryData> {
        protected ASN1ValueHolder basicCreateValueHolder() {
            return new ASN1ApplicationSpecificHolder(this.isExplicit(), 19, null);
        }

        public boolean isExplicit() {
            return false;
        }
    }
}

