/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.asn1;

import de.intarsys.security.algorithm.ec.EcTools;
import de.intarsys.tr3110.asn1.PublicKey;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;

public class PublicKeyECDH
extends PublicKey {
    public static final Factory FACTORY = new Factory();

    public ECPoint getPublic() {
        DEROctetString o = this.getValueHolder().getChild().getNextTaggedGetChild(0, 6, false).toDEROctetString();
        byte[] data = o.getOctets();
        return EcTools.decodeECPointX9Uncompressed((byte[])data);
    }

    public void setPublic(EllipticCurve curve, ECPoint value) {
        byte[] bytes = EcTools.encodeECPointX9Uncompressed((EllipticCurve)curve, (ECPoint)value);
        this.getValueHolder().getChild().setChild(1, (ASN1Encodable)new DERTaggedObject(false, 6, (ASN1Encodable)new DEROctetString(bytes)));
    }

    public static class Factory
    extends PublicKey.Factory<PublicKeyECDH> {
        @Override
        public boolean isExplicit() {
            return false;
        }
    }
}

