/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.asn1;

import de.intarsys.asn1.model.ASN1Any;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.tools.string.PrettyPrinter;
import de.intarsys.tr3110.asn1.CardInfoLocator;
import de.intarsys.tr3110.asn1.ChipAuthenticationDomainParameterInfo;
import de.intarsys.tr3110.asn1.ChipAuthenticationInfo;
import de.intarsys.tr3110.asn1.ChipAuthenticationPublicKeyInfo;
import de.intarsys.tr3110.asn1.EIDSecurityInfo;
import de.intarsys.tr3110.asn1.PACEDomainParameterInfo;
import de.intarsys.tr3110.asn1.PACEInfo;
import de.intarsys.tr3110.asn1.PrivilegedTerminalInfo;
import de.intarsys.tr3110.asn1.RestrictedIdentificationDomainParameterInfo;
import de.intarsys.tr3110.asn1.RestrictedIdentificationInfo;
import de.intarsys.tr3110.asn1.TerminalAuthenticationInfo;
import de.intarsys.tr3110.common.CommonTools;
import org.bouncycastle.asn1.ASN1Encodable;

public class SecurityInfo
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public static Factory findFactory(String protocol) {
        Factory[] factories;
        for (Factory factory : factories = new Factory[]{CardInfoLocator.FACTORY, ChipAuthenticationDomainParameterInfo.FACTORY, ChipAuthenticationInfo.FACTORY, ChipAuthenticationPublicKeyInfo.FACTORY, EIDSecurityInfo.FACTORY, PACEDomainParameterInfo.FACTORY, PACEInfo.FACTORY, PrivilegedTerminalInfo.FACTORY, RestrictedIdentificationDomainParameterInfo.FACTORY, RestrictedIdentificationInfo.FACTORY, TerminalAuthenticationInfo.FACTORY}) {
            if (!factory.isFactoryFor(protocol)) continue;
            return factory;
        }
        return FACTORY;
    }

    public ASN1Based getOptionalData() {
        return ASN1Any.FACTORY.create((ASN1Encodable)this.getValueHolder().getChild(2));
    }

    public String getProtocol() {
        return this.getValueHolder().getChild(0).toDERObjectIdentifier().getId();
    }

    public ASN1Based getRequiredData() {
        return ASN1Any.FACTORY.create((ASN1Encodable)this.getValueHolder().getChild(1));
    }

    public void toString(PrettyPrinter printer) {
        printer.appendMember("protocol", (Object)this.getProtocol(), CommonTools.resolveOid(this.getProtocol()));
    }

    public static class Factory<T extends SecurityInfo>
    extends ASN1Based.Factory<T> {
        public boolean isFactoryFor(String oid) {
            return false;
        }
    }
}

