/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.asn1;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.string.PrettyPrinter;
import de.intarsys.tr3110.asn1.ChipAuthenticationDomainParameterInfo;
import de.intarsys.tr3110.asn1.ChipAuthenticationInfo;
import de.intarsys.tr3110.asn1.PACEInfo;
import de.intarsys.tr3110.asn1.SecurityInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class SecurityInfos
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public List<ChipAuthenticationDomainParameterInfo> getChipAuthenticationDomainParameterInfos() {
        return this.getSecurityInfos(ChipAuthenticationDomainParameterInfo.FACTORY, Pattern.quote("0.4.0.127.0.7.2.2.3") + "\\..");
    }

    public List<ChipAuthenticationInfo> getChipAuthenticationInfos() {
        return this.getSecurityInfos(ChipAuthenticationInfo.FACTORY, Pattern.quote("0.4.0.127.0.7.2.2.3") + "\\..\\..");
    }

    public List<PACEInfo> getPACEInfos() {
        String selectPaceInfo = Pattern.quote("0.4.0.127.0.7.2.2.4") + "\\..\\..";
        return this.getSecurityInfos(PACEInfo.FACTORY, selectPaceInfo);
    }

    public <T extends SecurityInfo> List<T> getSecurityInfos(SecurityInfo.Factory<T> factory, String regex) {
        Pattern pattern = Pattern.compile(regex);
        ArrayList<SecurityInfo> result = new ArrayList<SecurityInfo>();
        for (int i = 0; i < this.size(); ++i) {
            ASN1ObjectIdentifier protocol;
            ASN1ValueHolder object = this.getValueHolder().getChild(i);
            if (object == null || !pattern.matcher((protocol = object.getChild(0).toDERObjectIdentifier()).getId()).matches()) continue;
            result.add((SecurityInfo)factory.create((ASN1Encodable)object));
        }
        return result;
    }

    public void toString(PrettyPrinter printer) {
        ASN1ValueHolder vh = this.getValueHolder();
        for (int i = 0; i < this.size(); ++i) {
            ASN1ValueHolder object = vh.getChild(i);
            if (object == null) continue;
            String protocol = object.getChild(0).toDERObjectIdentifier().getId();
            SecurityInfo.Factory factory = SecurityInfo.findFactory(protocol);
            ASN1Based info = factory.create((ASN1Encodable)object);
            printer.appendMember("" + i, (Object)info, null);
        }
    }

    public static class Factory
    extends ASN1Based.Factory<SecurityInfos> {
    }
}

