/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.common;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tr3110.asn1.CardVerifiableCertificate;
import de.intarsys.tr3110.asn1.CertificateHolderAuthorizationTemplate;
import de.intarsys.tr3110.asn1.CertificateReference;
import de.intarsys.tr3110.asn1.SecurityInfos;
import de.intarsys.tr3110.common.CommonOid;
import de.intarsys.tr3110.common.TerminalRoleRole;
import de.intarsys.tr3110.eac.CaOid;
import de.intarsys.tr3110.pace.PaceOid;
import de.intarsys.tr3110.ri.RiOid;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class CommonTools {
    private static final Attribute ATTR_SECURITY_INFOS = new Attribute("SecurityInfos");
    private static final Attribute ATTR_EF_CARD_ACCESS = new Attribute("EFCardAccess");

    public static List<CardVerifiableCertificate> buildCertificateChain(List<CardVerifiableCertificate> cvCertificates, CertificateReference authorityRef) {
        ArrayList<CardVerifiableCertificate> result = new ArrayList<CardVerifiableCertificate>();
        for (CardVerifiableCertificate cvcert : cvCertificates) {
            if (!cvcert.getCertificateBody().getCertificationAuthorityReference().equals(authorityRef)) continue;
            result.add(cvcert);
            result.addAll(CommonTools.buildCertificateChain(cvCertificates, cvcert.getCertificateBody().getCertificateHolderReference()));
            break;
        }
        return result;
    }

    protected static String findFieldNameWithValue(Class clazz, String value) {
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            try {
                String temp = (String)field.get(null);
                if (!value.equals(temp)) continue;
                return field.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static CardVerifiableCertificate getCertificateTerminalRoleBasic(List<CardVerifiableCertificate> cvCertificates) {
        for (CardVerifiableCertificate cvcert : cvCertificates) {
            CertificateHolderAuthorizationTemplate chat = cvcert.getCertificateBody().getChat();
            if (chat == null || chat.getTerminalRoleRole() != TerminalRoleRole.BASIC) continue;
            return cvcert;
        }
        return null;
    }

    public static byte[] getCompressedPublicKey(byte[] publicKey) {
        return null;
    }

    public static byte[] getEFCardAccess(ICardProduct product, ICardConnection connection) throws CardApplicationException {
        if (CommonTools.lookupEFCardAccess(connection) == null) {
            CommonTools.initEFCardAccess(product, connection);
        }
        return CommonTools.lookupEFCardAccess(connection);
    }

    public static SecurityInfos getSecurityInfos(ICardProduct product, ICardConnection connection) throws CardApplicationException {
        if (CommonTools.lookupSecurityInfos(connection) == null) {
            CommonTools.initSecurityInfos(product, connection);
        }
        return CommonTools.lookupSecurityInfos(connection);
    }

    public static void initEFCardAccess(ICardProduct product, ICardConnection connection) throws CardApplicationException {
        IFileSystemApplication fs = product.createCardApplication(connection, IFileSystemApplication.class);
        CardFileSelector selector = product.getCardInfo().lookupFileSelector("EF.CardAccess");
        byte[] efCardAccess = fs.readBinaryCached(selector);
        connection.getCard().setAttribute((Object)ATTR_EF_CARD_ACCESS, (Object)efCardAccess);
    }

    public static void initSecurityInfos(ICardProduct product, ICardConnection connection) throws CardApplicationException {
        SecurityInfos securityInfos;
        byte[] efCardAccess = CommonTools.getEFCardAccess(product, connection);
        try {
            securityInfos = (SecurityInfos)ASN1BasedTools.create((ASN1Based.Factory)SecurityInfos.FACTORY, (byte[])efCardAccess);
        }
        catch (IOException e) {
            throw CardApplicationException.create(e);
        }
        connection.getCard().setAttribute((Object)ATTR_SECURITY_INFOS, (Object)securityInfos);
    }

    protected static byte[] lookupEFCardAccess(ICardConnection connection) {
        return (byte[])connection.getCard().getAttribute((Object)ATTR_EF_CARD_ACCESS);
    }

    protected static SecurityInfos lookupSecurityInfos(ICardConnection connection) {
        return (SecurityInfos)((Object)connection.getCard().getAttribute((Object)ATTR_SECURITY_INFOS));
    }

    public static String resolveOid(String protocol) {
        Class[] classes = new Class[]{CommonOid.class, CaOid.class, RiOid.class, PaceOid.class};
        for (int i = 0; i < classes.length; ++i) {
            Class clazz = classes[i];
            String temp = CommonTools.findFieldNameWithValue(clazz, protocol);
            if (temp == null) continue;
            return temp;
        }
        return "<unknown>";
    }

    private CommonTools() {
    }
}

