/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.eac;

import de.intarsys.security.algorithm.ec.EcTools;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationAdapter;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvTemplate;
import de.intarsys.tr3110.asn1.Asn1Tools;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChipAuthenticationApplication
extends CardApplicationAdapter {
    private static final Logger Log = LoggerFactory.getLogger(ChipAuthenticationApplication.class);
    private byte[] nonce;
    private byte[] authenticationToken;

    public void generalAuthenticate(byte[] key) throws CardApplicationException {
        Log.trace("general authenticate");
        try {
            byte[] oidBytes = Asn1Tools.getElementContent((ASN1Encodable)new ASN1ObjectIdentifier("0.4.0.127.0.7.2.2.3.2.2"));
            TlvTemplate data = new TlvTemplate();
            data.addElement((TlvElement)new Iso7816BerElement(128, oidBytes));
            this.cmd("general authenticate", 0, 34, 65, 164, data.getEncoded(), -1);
        }
        catch (Exception e) {
            throw CardApplicationException.create(e);
        }
        Iso7816BerElement tlvKey = new Iso7816BerElement(128, EcTools.sanitizeECPointX9Uncompressed((byte[])key));
        Iso7816BerElement tlvData = new Iso7816BerElement(124, tlvKey.getEncoded());
        ResponseAPDU resp = this.cmd(null, 0, 134, 0, 0, tlvData.getEncoded(), 0);
        byte[] respData = resp.getData();
        try {
            Iso7816BerElement respTlv = Iso7816BerElement.parseElement(respData, 0, respData.length);
            TlvTemplate dadTlv = respTlv.getTemplate();
            this.nonce = dadTlv.getElementTagged(129).getValue();
            this.authenticationToken = dadTlv.getElementTagged(130).getValue();
        }
        catch (IOException e) {
            throw CardApplicationException.create(e);
        }
    }

    @Override
    public IPinInfo getAuthenticationPinInfo() {
        return null;
    }

    public byte[] getAuthenticationToken() {
        return this.authenticationToken;
    }

    @Override
    protected Class<? extends ICardApplication> getCardApplicationType() {
        return ChipAuthenticationApplication.class;
    }

    @Override
    protected String getMsgPromptCodePrefix() {
        return "ChipAuthenticationApp";
    }

    public byte[] getNonce() {
        return this.nonce;
    }
}

