/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.eac;

import de.intarsys.security.algorithm.ec.EcTools;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationAdapter;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.cmd.ICmdManageSecurityEnvironment;
import de.intarsys.security.smartcard.model.cmd.ICmdPerformSecurityOperation;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvTemplate;
import de.intarsys.tr3110.asn1.Asn1Tools;
import de.intarsys.tr3110.asn1.CardVerifiableCertificate;
import de.intarsys.tr3110.asn1.CertificateReference;
import de.intarsys.tr3110.common.CommonTools;
import java.io.IOException;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalAuthenticationApplication
extends CardApplicationAdapter {
    private static final Logger Log = LoggerFactory.getLogger(TerminalAuthenticationApplication.class);
    private List<CardVerifiableCertificate> cvCertificates;
    private CertificateReference certificationAuthority;
    private byte[] auxiliaryData;
    private byte[] ephemeralPublicKey;
    private byte[] challenge;

    protected ResponseAPDU cmdMseVerifyDst(CertificateReference ref) throws CardApplicationException {
        Iso7816BerElement element = new Iso7816BerElement(131, ref.getEncoded());
        ICmdManageSecurityEnvironment cmd = this.getCommand(ICmdManageSecurityEnvironment.class);
        RequestAPDU req = cmd.createRaw(129, 182, element.getEncoded());
        return this.sendRequest(cmd, req);
    }

    protected ResponseAPDU cmdPsoVerifyCertificate(byte[] data) throws CardApplicationException {
        ICmdPerformSecurityOperation cmd = this.getCommand(ICmdPerformSecurityOperation.class);
        RequestAPDU req = cmd.createVerifyCertificate(data);
        return this.sendRequest(cmd, req);
    }

    protected byte[] compress(byte[] encoded) throws IOException {
        int offset = 1;
        int numLength = (encoded.length - offset) / 2;
        byte[] xEnc = new byte[numLength];
        System.arraycopy(encoded, offset, xEnc, 0, xEnc.length);
        return xEnc;
    }

    public void externalAuthenticate(byte[] signature) throws CardApplicationException {
        Log.trace("external authenticate");
        this.cmd("external authenticate", 0, 130, 0, 0, signature, -1);
    }

    @Override
    public IPinInfo getAuthenticationPinInfo() {
        return null;
    }

    public byte[] getAuxiliaryData() {
        return this.auxiliaryData;
    }

    @Override
    protected Class<? extends ICardApplication> getCardApplicationType() {
        return TerminalAuthenticationApplication.class;
    }

    public CertificateReference getCertificationAuthority() {
        return this.certificationAuthority;
    }

    public byte[] getChallenge() throws CardApplicationException {
        if (this.challenge == null) {
            ResponseAPDU resp = this.cmd("get challenge", 0, 132, 0, 0, null, 8);
            this.challenge = Arrays.copyOf((byte[])resp.getData(), (int)8);
        }
        return this.challenge;
    }

    public List<CardVerifiableCertificate> getCvCertificates() {
        return this.cvCertificates;
    }

    public byte[] getEphemeralPublicKey() {
        return this.ephemeralPublicKey;
    }

    @Override
    protected String getMsgPromptCodePrefix() {
        return "TerminalAuthenticationApp";
    }

    public void perform() throws CardApplicationException {
        Object data;
        List<CardVerifiableCertificate> chain = CommonTools.buildCertificateChain(this.cvCertificates, this.getCertificationAuthority());
        for (CardVerifiableCertificate cvcert : chain) {
            byte[] body;
            CertificateReference ref = cvcert.getCertificateBody().getCertificationAuthorityReference();
            Log.debug("TA verify using " + ref);
            this.cmdMseVerifyDst(ref);
            try {
                body = cvcert.getCertificateBody().getDEREncoded();
            }
            catch (IOException e) {
                throw CardApplicationException.create(e);
            }
            byte[] signature = cvcert.getSignatureEncoded();
            data = new byte[body.length + signature.length];
            System.arraycopy(body, 0, data, 0, body.length);
            System.arraycopy(signature, 0, data, body.length, signature.length);
            this.cmdPsoVerifyCertificate((byte[])data);
        }
        CardVerifiableCertificate terminalCertificate = chain.get(chain.size() - 1);
        try {
            ASN1ObjectIdentifier oid = terminalCertificate.getCertificateBody().getPublicKey().getIdentifierOID();
            byte[] oidBytes = Asn1Tools.getElementContent((ASN1Encodable)oid);
            CertificateReference chr = terminalCertificate.getCertificateBody().getCertificateHolderReference();
            byte[] cpk = this.compress(this.getEphemeralPublicKey());
            data = new TlvTemplate();
            data.addElement((TlvElement)new Iso7816BerElement(128, oidBytes));
            data.addElement((TlvElement)new Iso7816BerElement(131, chr.getEncoded()));
            data.addElement((TlvElement)Iso7816BerElement.parseElement(this.getAuxiliaryData(), 0, this.getAuxiliaryData().length));
            data.addElement((TlvElement)new Iso7816BerElement(145, cpk));
            this.cmd("manage security environment, set AT", 0, 34, 129, 164, data.getEncoded(), -1);
        }
        catch (IOException e) {
            throw CardApplicationException.create(e);
        }
    }

    public void setAuxiliaryData(byte[] auxiliaryData) {
        this.auxiliaryData = auxiliaryData;
    }

    public void setCertificationAuthority(CertificateReference certificationAuthorityReference) {
        this.certificationAuthority = certificationAuthorityReference;
    }

    public void setCvCertificates(List<CardVerifiableCertificate> certificates) {
        this.cvCertificates = certificates;
    }

    public void setEphemeralPublicKey(byte[] ephemeralPublicKey) {
        this.ephemeralPublicKey = EcTools.sanitizeECPointX9Uncompressed((byte[])ephemeralPublicKey);
    }
}

