/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.pace;

import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tr3110.pace.DomainParametersECDH;
import de.intarsys.tr3110.pace.KeyAgreementFunction;

public class DomainParameters {
    public static final String CURVE_SECP512R1 = "secp512r1";
    public static final String CURVE_BRAINPOOLP512R1 = "brainpoolp512r1";
    public static final String CURVE_BRAINPOOLP384R1 = "brainpoolp384r1";
    public static final String CURVE_SECP384R1 = "secp384r1";
    public static final String CURVE_BRAINPOOLP320R1 = "brainpoolp320r1";
    public static final String CURVE_BRAINPOOLP256R1 = "brainpoolp256r1";
    public static final String CURVE_SECP256R1 = "secp256r1";
    public static final String CURVE_BRAINPOOLP224R1 = "brainpoolp224r1";
    public static final String CURVE_SECP224R1 = "secp224r1";
    public static final String CURVE_BRAINPOOLP192R1 = "brainpoolp192r1";
    public static final String CURVE_SECP192R1 = "secp192r1";

    public static DomainParameters create(int index) throws CardApplicationException {
        switch (index) {
            case 8: {
                return new DomainParametersECDH(CURVE_SECP192R1);
            }
            case 9: {
                return new DomainParametersECDH(CURVE_BRAINPOOLP192R1);
            }
            case 10: {
                return new DomainParametersECDH(CURVE_SECP224R1);
            }
            case 11: {
                return new DomainParametersECDH(CURVE_BRAINPOOLP224R1);
            }
            case 12: {
                return new DomainParametersECDH(CURVE_SECP256R1);
            }
            case 13: {
                return new DomainParametersECDH(CURVE_BRAINPOOLP256R1);
            }
            case 14: {
                return new DomainParametersECDH(CURVE_BRAINPOOLP320R1);
            }
            case 15: {
                return new DomainParametersECDH(CURVE_SECP384R1);
            }
            case 16: {
                return new DomainParametersECDH(CURVE_BRAINPOOLP384R1);
            }
            case 17: {
                return new DomainParametersECDH(CURVE_BRAINPOOLP512R1);
            }
            case 18: {
                return new DomainParametersECDH(CURVE_SECP512R1);
            }
        }
        throw new CardApplicationException("PACE domain parameters " + index + " not supported");
    }

    public KeyAgreementFunction createKeyAgreementFunction() {
        return null;
    }
}

