/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.pace;

import de.intarsys.tr3110.pace.DomainParameters;
import de.intarsys.tr3110.pace.KeyAgreementFunction;
import de.intarsys.tr3110.pace.KeyAgreementWithECDH;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainParametersECDH
extends DomainParameters {
    private static final Logger Log = LoggerFactory.getLogger(DomainParametersECDH.class);
    private final String name;

    public DomainParametersECDH(String name) {
        this.name = name;
    }

    protected ECParameterSpec createECParameterSpec() {
        if (this.getName() == null) {
            Log.trace("DomainParametersECDH no name");
            return null;
        }
        ECNamedCurveParameterSpec bcParams = ECNamedCurveTable.getParameterSpec((String)this.getName());
        if (bcParams == null) {
            Log.trace("DomainParametersECDH no parameter spec");
            return null;
        }
        Log.trace("DomainParametersECDH create parameter spec for " + this.getName());
        EllipticCurve curve = EC5Util.convertCurve((ECCurve)bcParams.getCurve(), null);
        return EC5Util.convertSpec((EllipticCurve)curve, (org.bouncycastle.jce.spec.ECParameterSpec)bcParams);
    }

    @Override
    public KeyAgreementFunction createKeyAgreementFunction() {
        return new KeyAgreementWithECDH(this.createECParameterSpec());
    }

    public String getName() {
        return this.name;
    }
}

